% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pLOH_score.R
\name{get_pLOH_score}
\alias{get_pLOH_score}
\title{Get proportions of pLOH score from Allele Specific Copy Number Profile}
\usage{
get_pLOH_score(data, rm_chrs = c("chrX", "chrY"), genome_build = "hg19")
}
\arguments{
\item{data}{a CopyNumber object or a \code{data.frame} containing at least
'chromosome', 'start', 'end', 'segVal', "minor_cn", 'sample' these columns.}

\item{rm_chrs}{chromosomes to be removed in calculation. Default is sex
chromosomes (recommended).}

\item{genome_build}{genome build version, should be 'hg19', 'hg38', 'mm9' or 'mm10'.}
}
\value{
A \code{data.frame}
}
\description{
pLOH score represents the genome that displayed LOH.
}
\examples{
\donttest{
# Load toy dataset of absolute copynumber profile
load(system.file("extdata", "toy_segTab.RData",
  package = "sigminer", mustWork = TRUE
))

set.seed(1234)
segTabs$minor_cn <- sample(c(0, 1), size = nrow(segTabs), replace = TRUE)
cn <- read_copynumber(segTabs,
  seg_cols = c("chromosome", "start", "end", "segVal"),
  genome_measure = "wg", complement = TRUE, add_loh = TRUE
)

df <- get_pLOH_score(cn)
df

df2 <- get_pLOH_score(cn@data)
df2
}
}
\references{
Steele, Christopher D., et al. "Signatures of copy number alterations in human cancer." bioRxiv (2021).
}
