% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EmpiricalFns.R
\name{estimateDifferenceZeroCrossing}
\alias{estimateDifferenceZeroCrossing}
\title{Studentized estimate of how often a difference is below zero.}
\usage{
estimateDifferenceZeroCrossing(resampledDiffs, na.rm = FALSE)
}
\arguments{
\item{resampledDiffs}{numeric vector resampled observations}

\item{na.rm}{logical, if TRUE remove NA values}
}
\value{
estimated probbility of seeing a re-sampled difference below zero.
}
\description{
Studentized estimate of how often a difference is below zero.
}
\examples{

set.seed(2352)
resampledDiffs <- rnorm(10)+1
estimateDifferenceZeroCrossing(resampledDiffs)

}
