% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TInterval.R
\name{TInterval.data.frame}
\alias{TInterval.data.frame}
\title{Student-T tolerance-style interval around an estimate of a mean from a data.frame.}
\usage{
\method{TInterval}{data.frame}(x, ColumnName, ..., conf.level = 0.95,
  na.rm = FALSE)
}
\arguments{
\item{x}{data.frame}

\item{ColumnName}{character name of measurment column}

\item{...}{extra arguments passed to TInterval}

\item{conf.level}{confidence level to draw interval}

\item{na.rm}{logical, if TRUE remove NA values}
}
\value{
wrapped stat
}
\description{
Student-T tolerance-style interval around an estimate of a mean from a data.frame.
}
\examples{

set.seed(2018)
d <- data.frame(x = rnorm(100) + 3.2)
TInterval(d, "x")


}
\seealso{
\code{\link{TInterval}}, \code{\link{TIntervalS}}, \code{\link{TInterval.numeric}}, \code{\link{TInterval.data.frame}}
}
