% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination.R
\name{generateRecombinationDistances}
\alias{generateRecombinationDistances}
\title{Generate inter-recombination distances using a chi-square model. Note this are the distances between two succesive recombination events and not
the absolute positions of the events. To generate the locations of the recombination events see the example below.}
\usage{
generateRecombinationDistances(n)
}
\arguments{
\item{n}{Number of distances to generate}
}
\value{
vector of distances between two recombination events.
}
\description{
Generate inter-recombination distances using a chi-square model. Note this are the distances between two succesive recombination events and not
the absolute positions of the events. To generate the locations of the recombination events see the example below.
}
\examples{

library("sim1000G")

distances = generateRecombinationDistances(20)


positions_of_recombination = cumsum(distances)



}
