% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination.R
\name{generateUniformGeneticMap}
\alias{generateUniformGeneticMap}
\title{Generates a uniform genetic map.}
\usage{
generateUniformGeneticMap()
}
\description{
Generates a uniform genetic map by approximating 1 cm / Mbp. Only used for examples.
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = sprintf("\%s/region.vcf.gz", examples_dir)
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 ,
               min_maf = 0.12 ,max_maf = NA)

# For realistic data use the function readGeneticMap
generateUniformGeneticMap()

pdf(file=tempfile())
plotRegionalGeneticMap(seq(1e6,100e6,by=1e6/2))
dev.off()

}
