% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{computePairIBD2}
\alias{computePairIBD2}
\title{Computes pairwise IBD2 for a specific pair of individuals}
\usage{
computePairIBD2(i, j)
}
\arguments{
\item{i}{Index of first individual}

\item{j}{Index of second individual}
}
\value{
Mean IBD2 as computed from shared haplotypes
}
\description{
Computes pairwise IBD2 for a specific pair of individuals
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = file.path(examples_dir, "region.vcf.gz")
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 ,
               min_maf = 0.12 ,max_maf = NA)

# For realistic data use the function downloadGeneticMap
generateUniformGeneticMap()

startSimulation(vcf, totalNumberOfIndividuals = 200)

ped1 = newNuclearFamily(1)

v = computePairIBD2(1, 3)

cat("IBD2 of pair = ", v, "\\n");

}
