% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_ActualVapourPressure_from_RHmaxAndRHmin}
\alias{cal_ActualVapourPressure_from_RHmaxAndRHmin}
\title{Actual vapour pressure derived from RHmax and RHmin}
\usage{
cal_ActualVapourPressure_from_RHmaxAndRHmin(Tmax, Tmin, RHmax, RHmin)
}
\arguments{
\item{Tmax}{daily maximum temperature (kPa).}

\item{Tmin}{daily minimum temperature (KPa).}

\item{RHmax}{maximum relative humidity  \%.}

\item{RHmin}{minimum relative humidity  \%.}
}
\value{
A vector for actual vapour pressure
}
\description{
The actual vapour pressure can also be calculated from the
   relative humidity. Depending on the availability of the humidity data,
   different equations should be used.
}
\details{
For periods of a week, ten days or a month, RHmax and RHmin are
   obtained by dividing the sum of the daily values by the number of days
   in that period.
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M.
   FAO Irrigation and drainage paper No. 56. Rome: Food and Agriculture
   Organization of the United Nations, 1998.
}
