\name{vgeom}
\alias{vgeom}
\alias{Geometric}

\title{Variate Generator for the Geometric Distribution}
\description{
  Generates random variates from the geometric distribution, with options for
  independent streams and antithetic variates.
}
\usage{
  vgeom(n, prob, stream = NULL, antithetic = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{number of observations}
  \item{prob}{probability of success in each trial (0 \eqn{<} \code{prob} \eqn{\le} 1)}
  \item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
    to generate uniform variates to invert via \code{\link[=qgeom]{stats::qgeom}}; 
    otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
    from which to generate uniform variates to invert via
    \code{\link[=qgeom]{stats::qgeom}}}
  \item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
    variate(s) generated via either \code{\link[=runif]{stats::runif}} or
    \code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
    \eqn{1 - u}}
}
\details{
  Generates random variates from the geometric distribution.

  Geometric variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}} (if
  \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qgeom]{stats::qgeom}} is used to invert the
  uniform(0,1) variate(s).
  In this way, using \code{vgeom} provides a monotone and synchronized
  geometric variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

  The geometric distribution with parameter \code{prob} = \eqn{p} has density

           \deqn{p(x) = p (1-p)^x}

  for \eqn{x = 0, 1, 2, \ldots}, where \eqn{0 < p \le 1}.
}
\value{
  A vector of geometric random variates.
}
\seealso{
    \code{\link[=rgeom]{stats::rgeom}}, \code{\link[=runif]{stats::runif}},
    \code{\link{rstream}}, \code{\link{set.seed}}
}
\author{Barry Lawson (\email{blawson@richmond.edu}), 
        Larry Leemis (\email{leemis@math.wm.edu})}
\examples{
set.seed(8675309)
vgeom(3, prob = 0.3)  # inverts stats::runif using stats::qgeom

set.seed(8675309)
vgeom(3, 0.3, stream = 1) # inverts rstream::rstream.sample using stats::qgeom
vgeom(3, 0.3, stream = 2)

set.seed(8675309)
vgeom(1, 0.3, stream = 1) # inverts rstream::rstream.sample using stats::qgeom
vgeom(1, 0.3, stream = 2)
vgeom(1, 0.3, stream = 1)
vgeom(1, 0.3, stream = 2)
vgeom(1, 0.3, stream = 1)
vgeom(1, 0.3, stream = 2)

set.seed(8675309)
variates <- vgeom(1000, prob = 0.3, stream = 1)
set.seed(8675309)
variates <- vgeom(1000, prob = 0.3, stream = 1, antithetic = TRUE)
}
\keyword{distribution}  % RShowDoc("KEYWORDS") for suggested list
\concept{random variate generation}
