\name{vexp}
\alias{vexp}
\alias{Exponential}

\title{Variate Generator for the Exponential Distribution}
\description{
  Generates random variates from the exponential distribution, with options for
  independent streams and antithetic variates.
}
\usage{
  vexp(n, rate = 1, stream = NULL, antithetic = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n     }{number of observations}
  \item{rate  }{rate parameter;  must be positive}
  \item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
    to generate uniform variates to invert via \code{\link[=qexp]{stats::qexp}}; 
    otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
    from which to generate uniform variates to invert via
    \code{\link[=qexp]{stats::qexp}}}
  \item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
    variate(s) generated via either \code{\link[=runif]{stats::runif}} or
    \code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
    \eqn{1 - u}}
}
\details{
  Generates random variates from the exponential distribution.

  Exponential variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}} (if
  \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qexp]{stats::qexp}} is used to invert the
  uniform(0,1) variate(s).
  In this way, using \code{vexp} provides a monotone and synchronized
  exponential variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

  If \code{rate} is not specified, it assumes the default value of 1.

  The exponential distribution with rate \eqn{\lambda} has density

           \deqn{f(x) = \lambda e^{-\lambda x}}{%
                 f(x) = \lambda e^(-\lambda x)}
           
           
  for \eqn{x \ge 0}.
}
\value{
  A vector of exponential random variates.
}
\seealso{
    \code{\link[=rexp]{stats::rexp}}, \code{\link[=runif]{stats::runif}},
    \code{\link{rstream}}, \code{\link{set.seed}}
}
\author{Barry Lawson (\email{blawson@richmond.edu}), 
        Larry Leemis (\email{leemis@math.wm.edu})}
\examples{
set.seed(8675309)
vexp(3)  # inverts stats::runif using stats::qexp

set.seed(8675309)
vexp(3, rate = 2)  # inverts stats::runif using stats::qexp

set.seed(8675309)
vexp(3, rate = 2, stream = 1) # inverts rstream::rstream.sample using stats::qexp
vexp(3, rate = 2, stream = 2)

set.seed(8675309)
vexp(1, rate = 2, stream = 1) # inverts rstream::rstream.sample using stats::qexp
vexp(1, rate = 2, stream = 2)
vexp(1, rate = 2, stream = 1)
vexp(1, rate = 2, stream = 2)
vexp(1, rate = 2, stream = 1)
vexp(1, rate = 2, stream = 2)

set.seed(8675309)
interarrivals <- vexp(1000, rate = 1,    stream = 1)
services      <- vexp(1000, rate = 10/9, stream = 2)

set.seed(8675309)
interarrivals <- vexp(1000, rate = 1,    stream = 1, antithetic = TRUE)
services      <- vexp(1000, rate = 10/9, stream = 2, antithetic = TRUE)
}
\keyword{distribution}  % RShowDoc("KEYWORDS") for suggested list
\concept{random variate generation}
