% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vunif}
\alias{vunif}
\title{Variate Generation for Uniform Distribution}
\usage{
vunif(n, min = 0, max = 1, stream = NULL, antithetic = FALSE, asList = FALSE)
}
\arguments{
\item{n}{number of observations}

\item{min}{lower limit of distribution (default 0)}

\item{max}{upper limit of distribution (default 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates;
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates;}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

Otherwise, return a list with components suitable for visualizing inversion,
specifically:
\item{u}{        A vector of generated U(0,1) variates }
\item{x}{        A vector of uniform random variates }
\item{quantile}{ Parameterized quantile function }
\item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Uniform Distribution
}
\details{
Generates random variates from the uniform distribution.

Uniform variates are generated by inverting uniform(0,1) variates
produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
\code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
(if \code{stream} is not \code{NULL}).
In either case, \code{\link[=qunif]{stats::qunif}} is used to
invert the uniform(0,1) variate(s).
In this way, using \code{vunif} provides a monotone and synchronized
binomial variate generator, although not particularly fast.

The stream indicated must be an integer between 1 and 25 inclusive.

The uniform distribution has density

\if{html}{\out{<div class="sourceCode">}}\preformatted{      \deqn{f(x) = \frac{1}{max-min}}{%
                f(x) = 1/(max-min)}
}\if{html}{\out{</div>}}

for \eqn{min \le x \le max}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qunif
 vunif(3, min = -2, max = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qunif
 vunif(3, 0, 10, stream = 1)
 vunif(3, 0, 10, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qunif
 vunif(1, 0, 10, stream = 1)
 vunif(1, 0, 10, stream = 2)
 vunif(1, 0, 10, stream = 1)
 vunif(1, 0, 10, stream = 2)
 vunif(1, 0, 10, stream = 1)
 vunif(1, 0, 10, stream = 2)

 set.seed(8675309)
 variates <- vunif(100, 0, 10, stream = 1)
 set.seed(8675309)
 variates <- vunif(100, 0, 10, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
\code{\link[=runif]{stats::runif}}

\code{\link[=runif]{stats::runif}}
}
\author{
Barry Lawson (\email{blawson@bates.edu}), \cr
Larry Leemis (\email{leemis@math.wm.edu}), \cr
Vadim Kudlay (\email{vkudlay@nvidia.com})
}
\concept{random variate generation}
\keyword{distribution}
