% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{simDefect}
\alias{simDefect}
\title{Local damage accumulation}
\usage{
simDefect(stress, S, CLT, opt)
}
\arguments{
\item{stress}{stress level}

\item{S}{non-overlapping geometry system}

\item{CLT}{the start (initialized) cluster of objects}

\item{opt}{control list of fixed parameters, see \code{\link{simTimes}}}
}
\value{
list of clusters, the following values are returned for further analysis:
					\itemize{
						\item{id}{ the object id numbers in the accumulated defect}
						\item{n}{ internal: accumulated defect id, zero means last element of cluster}
						\item{B}{ corresponding defect types of projected objects}
						\item{interior}{ whether each object is interior or not}
						\item{A}{ projected areas, possibly convex area}
						\item{inner}{ whether the defect lies in the interior or not}
						\item{T}{ random individual times}
						\item{label}{ phase labels }
						\item{areaMax}{ attribute, the maximum area of defect projections}
						\item{aIn}{ attribute, critical area for inner defect projections}
						\item{aOut}{ attribute, critical area for outer defect projections}
						\item{maxSize}{ attribute, maximum number of projected objects found in a defect}
					}
}
\description{
Simulate fatigue lifetime of the geometry system
}
\details{
The function simulates the fatigue lifetime model for the given geometry system. The overall fatigue lifetime
is determined by the first accumulated convex area of projected defects which exceeds the
predefined critical area. The process of defect accumulation is based on the general results for VHCF fatigue behaviour of
material structures published by Murakami. Here we treat two nearby defects as an enlarged
common one if the weighted (single-linkage) Euclidean distance inbetween (in 3D) is less than some portion (possibly including
some material specific constant) of the minimum of the corresponding square roots of projected defect areas. The weight is chosen
as the reciprocal value of the cosine of the angle between the main load direction and the rotational axis of the chosen object
having minimum distance to the compared defect .
Further, the argument \code{opt} defines the list of controls of fixed parameters with the following elements:
\code{vickers} Vickers hardness, \code{distTol} as a (proportion) factor of the minium the corresponding square roots of
projected defect areas (might be less than 0.95 but in general depends on the inverstigated material structure),
\code{inAreafactor} default set to value 1.56, \code{outAreafactor} default set to value 1.43, \code{pointsConvHull} number of
sampling points of each objects projection border for approximating the defect projection convex area, \code{scale} scaling factor
(should be set to \code{1e+06} for \eqn{\mu m^2}), \code{pl} print level of information output with some verbose messages for any value
larger than 100. In this case only the accumulated defect projections after adding the last individual failed object are returned.
Here the last element contains the defect with the highest projected area which leads to the overall failure.
}
\author{
M. Baaske
}
