% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TestStability}
\alias{TestStability}
\title{Test Stability}
\usage{
TestStability(x)
}
\arguments{
\item{x}{Numeric matrix.}
}
\description{
The function computes the eigenvalues of the input matrix \code{x}.
It checks if the real part of all eigenvalues is negative.
If all eigenvalues have negative real parts,
the system is considered stable.
}
\examples{
x <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
TestStability(x)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{PBSSMFixed}()},
\code{\link{PBSSMLinSDEFixed}()},
\code{\link{PBSSMOUFixed}()},
\code{\link{PBSSMVARFixed}()},
\code{\link{SimBetaN}()},
\code{\link{SimPhiN}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{TestPhi}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
\keyword{test}
