% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.Ped}
\alias{simer.Data.Ped}
\title{Pedigree data quality control}
\usage{
simer.Data.Ped(
  filePed,
  fileMVP = NULL,
  out = NULL,
  standardID = FALSE,
  fileSir = NULL,
  fileDam = NULL,
  exclThres = 0.01,
  assignThres = 0.005,
  header = TRUE,
  sep = "\\t",
  ncpus = 0,
  verbose = TRUE
)
}
\arguments{
\item{filePed}{the filename of pedigree need correcting.}

\item{fileMVP}{genotype in MVP format.}

\item{out}{the prefix of output file.}

\item{standardID}{whether kid id is 15-character standard.}

\item{fileSir}{the filename of candidate sires.}

\item{fileDam}{the filename of candidate dams.}

\item{exclThres}{if conflict ratio is more than exclThres, exclude this parent.}

\item{assignThres}{if conflict ratio is less than assignThres, assign this parent to the individual.}

\item{header}{whether the file contains header.}

\item{sep}{separator of the file.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns files
\describe{
\item{<out>.report.ped}{the report file containing correction condition.}
\item{<out>.error.ped}{the file containing pedigree error.}
\item{<out>.ped}{the pedigree file after correction.}
}
}
\description{
Data quality control for pedigree data.
}
\details{
Build date: May 6, 2021
Last update: Apr 28, 2022
}
\examples{
# Get the filename of pedigree data
filePed <- system.file("extdata", "05others", "pedigree.txt", package = "simer")

# Run pedigree correction
simer.Data.Ped(filePed = filePed, out = tempfile("outfile"))
}
\author{
Lilin Yin and Dong Yin
}
