% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{checkEnv}
\alias{checkEnv}
\title{Environmental factor checking}
\usage{
checkEnv(data, envName, verbose = TRUE)
}
\arguments{
\item{data}{data needing check.}

\item{envName}{the environmental factor name within the data.}

\item{verbose}{whether to print detail.}
}
\value{
data without environmental factors of wrong level.
}
\description{
Check the levels of environmental factors.
}
\details{
Build date: Sep 10, 2021
Last update: Apr 28, 2022
}
\examples{
data <- data.frame(a = c(1, 1, 2), b = c(2, 2, 3), c = c(3, 3, 4))
envName <- c("a", "b", "c")
data <- checkEnv(data = data, envName = envName)
}
\author{
Dong Yin
}
