% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_glm.r
\name{data_glm_nested3}
\alias{data_glm_nested3}
\title{Simulates three level nested data with a single third level random effect}
\usage{
data_glm_nested3(Xmat, Zmat, Zmat3, beta, rand_eff, rand_eff3, k, n, p,
  outcome_type)
}
\arguments{
\item{Xmat}{A matrix of covariates.}

\item{Zmat}{Design matrix for random effects.}

\item{Zmat3}{Design matrix for level 3 random effects.}

\item{beta}{A vector of regression parameters.}

\item{rand_eff}{A vector of random effects, must be stacked.}

\item{rand_eff3}{A vector of level 3 random effects, must be stacked.}

\item{k}{Number of third level clusters.}

\item{n}{Number of clusters.}

\item{p}{Number of units within each cluster.}

\item{outcome_type}{A vector specifying the type of outcome, must be either
logistic or poisson. Logitstic outcome will be 0/1 and poisson outcome will
be counts.}
}
\description{
Takes simulation parameter arguments and 
returns simulated data for two different probability distributions. 
One is logistic (0/1) outcome and the second being poisson (count) outcomes.
}
