% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbimod.r
\name{rbimod}
\alias{rbimod}
\title{Simulating mixture normal distributions}
\usage{
rbimod(n, mean, var, num_dist)
}
\arguments{
\item{n}{Number of random draws.  Optionally can be a vector with number 
in each simulated normal distribution.}

\item{mean}{Vector of mean values for each normal distribution.
Must be the same length as num_dist.}

\item{var}{Vector of variance values for each normal distribution.
Must be the same length as num_dist.}

\item{num_dist}{Number of normal distributions to use when simulating mixture
normal distribution.}
}
\description{
Input simulation metrics returns mixture normal random variable.
}
\details{
Function to simulate mixture normal distributions.  The function computes
adds the specified number of normal distributions into a single vector.

Use of the function \code{\link{desireVar}} can be used to generate a mixture 
normal distribution with a specific global variance.
}
\examples{
\donttest{
## mix normal with two normal distributions (bimodal)
simData <- rbimod(100, mean = c(-2, 3), var = c(1.5, 1.5), num_dist = 2)
plot(density(simData))

## mixt normal with four distributions (multimodal)
simData <- rbimod(400, mean = c(-14, -4, 6, 20), var = c(rep(1.2, 4)), 
  num_dist = 4)
plot(density(simData))
}
}
