% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_coverage.R
\name{calc_coverage}
\alias{calc_coverage}
\title{Calculate confidence interval coverage, width and MCSE}
\usage{
calc_coverage(
  data,
  lower_bound,
  upper_bound,
  true_param,
  criteria = c("coverage", "width")
)
}
\arguments{
\item{data}{data frame or tibble containing the simulation results.}

\item{lower_bound}{Vector or name of column from \code{data} containing lower bounds of confidence intervals.}

\item{upper_bound}{Vector or name of column from \code{data} containing upper bounds of confidence intervals.}

\item{true_param}{Vector or name of column from \code{data} containing corresponding true parameters.}

\item{criteria}{character or character vector indicating the performance criteria to be calculated.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates confidence interval coverage and width. The function also calculates the associated
Monte Carlo standard errors. The confidence interval percentage is based on how you calculated the lower
and upper bounds.
}
\examples{
calc_coverage(data = t_res, lower_bound = lower_bound,
              upper_bound = upper_bound, true_param = true_param)


}
