% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_relative.R
\name{calc_relative}
\alias{calc_relative}
\title{Calculate relative performance criteria and MCSE}
\usage{
calc_relative(
  data,
  estimates,
  true_param,
  criteria = c("relative bias", "relative mse", "relative rmse")
)
}
\arguments{
\item{data}{data frame or tibble containing the simulation results.}

\item{estimates}{Vector or name of column from \code{data} containing point estimates.}

\item{true_param}{Vector or name of column from \code{data} containing corresponding true parameters.}

\item{criteria}{character or character vector indicating the performance criteria to be calculated.}
}
\value{
A tibble containing the number of simulation iterations, performance criteria estimate(s)
and the associated MCSE.
}
\description{
Calculates relative bias, mean squared error (relative mse), and root mean squared error (relative rmse).
The function also calculates the associated
Monte Carlo standard errors.
}
\examples{
calc_relative(data = t_res, estimates = est, true_param = true_param)


}
