% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator.R
\name{simmer}
\alias{simmer}
\title{Create a simulator}
\usage{
simmer(name = "anonymous", verbose = FALSE)
}
\arguments{
\item{name}{the name of the simulator.}

\item{verbose}{enable showing activity information.}
}
\value{
Returns a simulation environment.
}
\description{
This function initialises a simulation environment.
}
\examples{
t0 <- create_trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)

env <- simmer("SuperDuperSim") \%>\%
  add_resource("nurse", 1) \%>\%
  add_resource("doctor", 2) \%>\%
  add_resource("administration", 1) \%>\%
  add_generator("patient", t0, function() rnorm(1, 10, 2))
  
env \%>\% run(until=80)

plot_resource_usage(env, "doctor")
}
\seealso{
Other methods for dealing with a simulation environment:
\link{reset}, \link{now}, \link{peek}, \link{onestep}, \link{run}, 
\link{add_resource}, \link{add_generator}, \link{get_mon_arrivals}, \link{get_mon_attributes},
\link{get_mon_resources}, \link{get_n_generated}, \link{get_capacity}, \link{get_queue_size},
\link{get_server_count}, \link{get_queue_count}.
}

