% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor-class.R
\name{monitor}
\alias{monitor}
\alias{monitor_mem}
\alias{monitor_delim}
\alias{monitor_csv}
\title{Create a Monitor}
\usage{
monitor(name, xptr, get_arrivals, get_attributes, get_resources,
  handlers = NULL, finalize = function() { })

monitor_mem()

monitor_delim(path = tempdir(), keep = FALSE, sep = " ", ext = ".txt",
  reader = read.delim, args = list(stringsAsFactors = FALSE))

monitor_csv(path = tempdir(), keep = FALSE, reader = read.csv,
  args = list(stringsAsFactors = FALSE))
}
\arguments{
\item{name}{an identifier to show when printed.}

\item{xptr}{an external pointer pointing to a C++ object derived from the
abstract class simmer::Monitor. See C++ API for further details and, in
particular, the \code{simmer/monitor.h} header.}

\item{get_arrivals}{a function to retrieve the arrivals tables. It must accept
the \code{xptr} as a first argument, even if it is not needed, and a boolean
\code{per_resource} as a second argument (see \code{\link{get_mon_arrivals}}).}

\item{get_attributes}{a function to retrieve the attributes table. It must accept
the \code{xptr} as a first argument, even if it is not needed.}

\item{get_resources}{a function to retrieve the resources table. It must accept
the \code{xptr} as a first argument, even if it is not needed.}

\item{handlers}{an optional list of handlers that will be stored in a slot of
the same name. For example, \code{monitor_mem} does not use this slot, but
\code{monitor_delim} and \code{monitor_csv} store the path to the created files.}

\item{finalize}{an optional function to be called when the object is destroyed.
For example, \code{monitor_mem} does not require any finalizer, but
\code{monitor_delim} and \code{monitor_csv} use this to remove the created
files when the monitor is destroyed.}

\item{path}{directory where files will be created (must exist).}

\item{keep}{whether to keep files on exit. By default, files are removed.}

\item{sep}{separator character.}

\item{ext}{file extension to use.}

\item{reader}{function that will be used to read the files.}

\item{args}{a list of further arguments for \code{reader}.}
}
\value{
A \code{monitor} object.
}
\description{
Methods for creating \code{monitor} objects for simulation environments.
}
\details{
The \code{monitor} method is a generic function to instantiate a
\code{monitor} object. It should not be used in general unless you want to
extend \code{simmer} with a custom monitor.

The in-memory monitor is enabled by default (\code{memory_mem}),
and it should the fastest.

For large simulations, or if the RAM footprint is an issue, you may
consider monitoring to disk. To that end, \code{monitor_delim} stores the values
in flat delimited files. The usual \code{\link{get_mon}_*} methods retrieve
data frames from such files using the \code{reader} provided. By default,
\code{\link[utils:read.table]{read.delim}} is used, but you may consider using faster
alternatives from other packages. It is also possible to \code{keep} the
files in a custom directory to read and post-process them in a separate
workflow.

\code{monitor_csv} is a special case of \code{monitor_delim} with
\code{sep=","} and \code{ext=".csv"}.
}
\examples{
mon <- monitor_csv()
mon

env <- simmer(mon=mon) \%>\%
  add_generator("dummy", trajectory() \%>\% timeout(1), function() 1) \%>\%
  run(10)
env

read.csv(mon$handlers$arrivals) # direct access
get_mon_arrivals(env)           # adds the "replication" column

}
