% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{set_trajectory}
\alias{set_trajectory}
\alias{set_source}
\title{Set Source Parameters}
\usage{
set_trajectory(.trj, sources, trajectory)

set_source(.trj, sources, object)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{sources}{the name(s) of the source(s) or a function returning the name(s).}

\item{trajectory}{the trajectory that the generated arrivals will follow.}

\item{object}{a function modelling the interarrival times (if the source type
is a generator; returning a negative value stops the generator) or a data frame
(if the source type is a data source).}
}
\value{
Returns the trajectory object.
}
\description{
Activities for modifying a source's trajectory or source object by name.
Sources must be defined in the simulation environment (see
\code{\link{add_generator}}, \code{\link{add_dataframe}}).
}
\examples{
traj1 <- trajectory() \%>\%
  timeout(1)

traj2 <- trajectory() \%>\%
  set_source("dummy", function() 1) \%>\%
  set_trajectory("dummy", traj1) \%>\%
  timeout(2)

simmer() \%>\%
  add_generator("dummy", traj2, function() 2) \%>\%
  run(6) \%>\%
  get_mon_arrivals()

}
\seealso{
\code{\link{activate}}, \code{\link{deactivate}}
}
