% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-methods.R
\name{join}
\alias{join}
\title{Join Trajectories}
\usage{
join(...)
}
\arguments{
\item{...}{trajectory objects.}
}
\value{
Returns a new trajectory object.
}
\description{
Concatenate any number of trajectories in the specified order.
}
\examples{
t1 <- trajectory() \%>\% seize("dummy", 1)
t2 <- trajectory() \%>\% timeout(1)
t3 <- trajectory() \%>\% release("dummy", 1)

## join can be used alone
join(t1, t2, t3)

## or can be chained in a trajectory definition
trajectory() \%>\%
  join(t1) \%>\%
  timeout(1) \%>\%
  join(t3)

}
\seealso{
\code{\link{Extract.trajectory}}, \code{\link{length.trajectory}},
\code{\link{get_n_activities}}.
}
