% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigraphs.R
\name{is_multigraph}
\alias{is_multigraph}
\title{Is this a multigraph?}
\usage{
is_multigraph(graph)
}
\arguments{
\item{graph}{Input graph.}
}
\value{
Logical scalar.
}
\description{
A multigraph has at least one pair or multiple edges,
edges connecting the same (ordered) pair of vertices.
}
\examples{
G <- graph(list(A = c("A", "B", "B"), B = c("A", "C"), C = "A"))
is_multigraph(G)

G2 <- simplify(G)
is_multigraph(G2)
}
\seealso{
Other multigraphs: \code{\link{is_loopy}},
  \code{\link{is_simple}}, \code{\link{remove_loops}},
  \code{\link{remove_multiple}}, \code{\link{simplify}}
}

