% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_vbar_fun.R
\name{ggplot_vbar_col}
\alias{ggplot_vbar_col}
\title{Vertical bar ggplot that is coloured.}
\usage{
ggplot_vbar_col(data, x_var, y_var, col_var, tip_var = NULL,
  x_labels = waiver(), x_pretty_n = 6, y_zero = TRUE,
  y_zero_line = TRUE, y_trans = "identity", y_labels = waiver(),
  y_pretty_n = 5, col_drop = FALSE, position = "stack", pal = NULL,
  legend_ncol = 3, width = 0.75, title = "[Title]",
  subtitle = NULL, x_title = "[X title]", y_title = "[Y title]",
  col_title = "", caption = NULL, legend_labels = NULL,
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, wrap_title = 70, wrap_subtitle = 80,
  wrap_x_title = 50, wrap_y_title = 50, wrap_col_title = 25,
  wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric, date or categorical variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Required input.}

\item{col_var}{Unquoted categorical variable to colour the bars. Required input.}

\item{tip_var}{Unquoted variable to be used as a customised tooltip in combination with plotly::ggplotly(plot). Defaults to NULL.}

\item{x_labels}{Argument to adjust the format of the x scale labels.}

\item{x_pretty_n}{The desired number of intervals on the x axis, as calculated by the pretty algorithm. Defaults to 6. Not applicable where isMobile equals TRUE.}

\item{y_zero}{TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_zero_line}{TRUE or FALSE whether to add a zero line in for when values are above and below zero. Defaults to TRUE.}

\item{y_trans}{A string specifying a transformation for the y axis scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{y_labels}{Argument to adjust the format of the y scale labels.}

\item{y_pretty_n}{The desired number of intervals on the y axis, as calculated by the pretty algorithm. Defaults to 5.}

\item{col_drop}{TRUE or FALSE of whether to drop unused levels from the legend. Defaults to FALSE.}

\item{position}{Whether bars are positioned by "stack" or "dodge". Defaults to "stack".}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{legend_ncol}{The number of columns in the legend.}

\item{width}{Width of bars. Defaults to 0.75.}

\item{title}{Title string. Defaults to [Title].}

\item{subtitle}{Subtitle string. Defaults to [Subtitle].}

\item{x_title}{X axis title string. Defaults to [X title].}

\item{y_title}{Y axis title string. Defaults to [Y title].}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_x_title}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_title}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within an app with the mobileDetect function, then use isMobile = input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Vertical bar ggplot that is coloured, but not facetted.
}
\examples{
library(dplyr)

plot_data <- storms \%>\%
  mutate(status = stringr::str_to_sentence(status)) \%>\%
  group_by(year, status) \%>\%
  summarise(average_wind = round(mean(wind), 2)) 

plot <- ggplot_vbar_col(data = plot_data, x_var = year, y_var = average_wind, col_var = status)

plot

plotly::ggplotly(plot)
}
