% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet_sf.R
\name{leaflet_sf}
\alias{leaflet_sf}
\title{Map of simple features in leaflet.}
\usage{
leaflet_sf(data, popup_var = NULL, pal = NULL, point_size = 1,
  line_size = 2, alpha = 0.1, basemap = "light", title = "[Title]",
  col_labels_dp = 1, col_labels = "[Feature]", map_id = "map")
}
\arguments{
\item{data}{An sf object of geometry type point/multipoint, linestring/multilinestring or polygon/multipolygon geometry type. Required input.}

\item{popup_var}{Quoted variable of a variable to include in the popup. If NULL, defaults to making a leafpop::popupTable of all columns.}

\item{pal}{Character vector of hex codes. Defaults to viridis. Use the pals package to find a suitable palette.}

\item{point_size}{Size of points (i.e. radius). Defaults to 1.}

\item{line_size}{Size of lines around features (i.e. weight). Defaults to 2.}

\item{alpha}{The opacity of the fill within features (i.e. fillOpacity). Defaults to 0.1.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{title}{A title string that will be wrapped into the legend. Defaults to "Title"}

\item{col_labels_dp}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{col_labels}{A vector of legend label values. Defaults to "[Feature]".}

\item{map_id}{The shiny map id for a leaflet map within a shiny app. For standard single-map apps, id "map" should be used. For dual-map apps, "map1" and "map2" should be used. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of simple features in leaflet that is not coloured.
}
\examples{
leaflet_sf(example_sf_point)
}
