% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf_sf.R
\name{leaf_sf}
\alias{leaf_sf}
\title{Simple feature leaflet map.}
\usage{
leaf_sf(
  data,
  popup = TRUE,
  popup_vars_vctr = NULL,
  popup_numeric_format = function(x) prettyNum(x, big.mark = "", scientific = FALSE),
  popup_vars_rename = snakecase::to_sentence_case,
  pal = pal_viridis_reorder(1),
  size_point = 2,
  size_line = 2,
  alpha_point = NULL,
  alpha_line = NULL,
  alpha_fill = NULL,
  basemap = "light",
  layer_id_var = NULL,
  group_id = NULL,
  map_id = "leaf"
)
}
\arguments{
\item{data}{An sf object of geometry type point/multipoint, linestring/multilinestring or polygon/multipolygon geometry type. Required input.}

\item{popup}{TRUE or FALSE of whether to have a popup.}

\item{popup_vars_vctr}{Vector of quoted variable names to include in the popup. If NULL, defaults to making a leafpop::popupTable of all columns.}

\item{popup_numeric_format}{A function to format all numeric variables within the popup column. Defaults to non-scientific. Use function(x) x to leave as is.}

\item{popup_vars_rename}{Function to rename column names for the popup. Defaults to snakecase::to_sentence_case. Use function(x) x to leave column names untransformed.}

\item{pal}{Character vector of hex codes.}

\item{size_point}{Size of points (i.e. radius). Defaults to 2.}

\item{size_line}{Size of lines around features (i.e. weight). Defaults to 2.}

\item{alpha_point}{The opacity of the points.}

\item{alpha_line}{The opacity of the outline.}

\item{alpha_fill}{The opacity of the fill.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{layer_id_var}{Unquoted variable to be used in shiny, so that in the event where a feature is clicked on, the value of this is returned for that feature (e.g. input$map_marker_click$id).}

\item{group_id}{The id name for the sf group.}

\item{map_id}{The map id for the leaflet map. Defaults to "leaf".}
}
\value{
A leaflet object.
}
\description{
Map of simple features in leaflet that is not coloured.
}
\examples{
\dontrun{
leaf_sf(example_point)

leaf_sf(example_polygon)
}

}
