% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf_stars.R
\name{leaf_stars_col}
\alias{leaf_stars_col}
\title{Stars leaflet map that is coloured.}
\usage{
leaf_stars_col(
  data,
  col_var,
  pal = NULL,
  pal_na = "#7F7F7F",
  pal_rev = FALSE,
  alpha_fill = 1,
  basemap = "light",
  col_breaks_n = 4,
  col_cuts = NULL,
  col_intervals_left = TRUE,
  col_labels = NULL,
  col_legend_none = FALSE,
  col_method = NULL,
  col_na_rm = FALSE,
  col_title = NULL,
  group_id = NULL,
  legend_id = NULL,
  map_id = "map"
)
}
\arguments{
\item{data}{A stars object. Required input.}

\item{col_var}{Unquoted attribute to colour the features by. Required input.}

\item{pal}{Character vector of hex codes.}

\item{pal_na}{The hex code or name of the NA colour to be used.}

\item{pal_rev}{Reverses the palette. Defaults to FALSE.}

\item{alpha_fill}{The opacity of the fill. Defaults to 1.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{col_breaks_n}{For a numeric colour variable, the desired number of intervals on the colour scale.}

\item{col_cuts}{A vector of cuts to colour a numeric variable. If "bin" is selected, the first number in the vector should be either -Inf or 0, and the final number Inf. If "quantile" is selected, the first number in the vector should be 0 and the final number should be 1. Defaults to quartiles.}

\item{col_intervals_left}{For a numeric colour variable, TRUE or FALSE of whether bins or quantiles are to be cut left-closed. Defaults to TRUE.}

\item{col_labels}{A function or named vector to modify the colour scale labels. Defaults to stringr::str_to_sentence if categorical, and scales::label_comma if numeric. Use function(x) x to keep labels untransformed.}

\item{col_legend_none}{TRUE or FALSE of whether to remove the legend.}

\item{col_method}{The method of colouring features, either "bin", "quantile", "continuous", or "category." If numeric, defaults to "bin".}

\item{col_na_rm}{TRUE or FALSE of whether to visualise col_var NA values. Defaults to FALSE.}

\item{col_title}{A title string that will be wrapped into the legend.}

\item{group_id}{The id name for the stars group.}

\item{legend_id}{The id name for the layerId of the legend.}

\item{map_id}{The map id for the leaflet map. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of stars in leaflet that is coloured.
}
\examples{
\dontrun{
library(simplevis)

leaf_stars_col(example_stars, 
                  col_var = nitrate, 
                  col_na_rm = TRUE)
}

}
