% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{sims_simulate}
\alias{sims_simulate}
\title{Simulate Datasets}
\usage{
sims_simulate(
  code,
  constants = nlist::nlist(),
  parameters = nlist::nlist(),
  monitor = ".*",
  stochastic = NA,
  latent = NA,
  nsims = 1,
  save = FALSE,
  path = ".",
  exists = FALSE,
  rdists = sims_rdists(),
  ask = getOption("sims.ask", TRUE),
  silent = FALSE
)
}
\arguments{
\item{code}{A string of the JAGS or R code to generate the data.
The JAGS code must not be in a data or model block.}

\item{constants}{An nlist object (or list that can be coerced to nlist)
specifying the values of nodes in code.
The values are included in the output dataset.}

\item{parameters}{An nlist object (or list that can be coerced to nlist)
specifying the values of nodes in code.
The values are not included in the output dataset.}

\item{monitor}{A character vector (or regular expression if a string)
specifying the names of the nodes in code to include in the dataset.
By default all nodes are included.}

\item{stochastic}{A logical scalar specifying whether to monitor
deterministic and stochastic (NA), only deterministic (FALSE)
or only stochastic nodes (TRUE).}

\item{latent}{A logical scalar specifying whether to monitor
observed and latent (NA), only latent (TRUE)
or only observed nodes (FALSE).}

\item{nsims}{A whole number between 1 and 1,000,000 specifying
the number of data sets to simulate. By default 1 data set is simulated.}

\item{save}{A flag specifying whether to return the data sets as
an \code{nlists} object or save in \code{path}. If \code{save = NA}
the datasets are returned as an \code{nlists} object and saved in \code{path}.}

\item{path}{A string specifying the path to the directory to save
the data sets in.}

\item{exists}{A flag specifying whether the \code{path} directory should
already exist (if \code{exists = NA} it doesn't matter).}

\item{rdists}{A character vector specifying the R functions to recognize
as stochastic.}

\item{ask}{A flag specifying whether to ask before deleting sims
compatible files.}

\item{silent}{A flag specifying whether to suppress warnings.}
}
\value{
By default an \code{\link[nlist:nlists]{nlist::nlists_object()}} of the simulated data.
Otherwise if \code{path} is defined saves the datasets as individual \code{.rds}
files and returns TRUE.
}
\description{
Simulates datasets using JAGS or R code. By default
returns the datasets as an \code{\link[nlist:nlists]{nlist::nlists_object()}}.
If \code{path} is provided then the datasets are written to the directory
as individual \code{.rds} files.
}
\details{
JAGS code is identified by the presence of '~' indicating a
stochastic variable node.
Otherwise code is assumed to be R code and stochastic variable nodes
are those where assignment is immediately succeeded
by a call to one of the functions named in \code{rdists}.

Both constants and parameters must be \verb{[nlist::nlist_object]s}
(or lists that can be coerced to such) .
The only difference between constants and parameters is that the values in
constants are appended to the output data while the values in parameters
are not.
Neither constants or parameters can include missing values nor can they
have elements with the same name.
Elements which are not in code are dropped with a warning
(unless \code{silent = TRUE} in which case the warning is suppressed).

Each set of simulated data set is written as a separate .rds file.
The files are labelled \code{data0000001.rds}, \code{data0000002.rds},
\code{data0000003.rds} etc.
The argument values are saved in the hidden file \code{.sims.rds}.

sims compatible files are those matching the regular expression
\verb{^((data\\\\\\\\d\\\{7,7\\\})|([.]sims))[.]rds$}.

Parallelization is implemented using the future package.
}
\examples{
set.seed(101)
sims_simulate("a <- runif(1)", path = tempdir(), exists = NA, ask = FALSE)
}
\seealso{
\code{\link[=sims_rdists]{sims_rdists()}}
}
