% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genCorOrdCat.R
\name{genCorOrdCat}
\alias{genCorOrdCat}
\title{Generate correlated ordinal categorical data}
\usage{
genCorOrdCat(
  dtName,
  idname = "id",
  adjVar = NULL,
  baseprobs,
  prefix = "grp",
  rho,
  corstr,
  corMatrix = NULL
)
}
\arguments{
\item{dtName}{Name of complete data set}

\item{idname}{A string. The id of the data.table that identifies a unique record.
Defaults to "id".}

\item{adjVar}{Vector of adjustment variables name in dtName - determines
logistic shift. This is specified assuming a cumulative logit
link. The vector can be NULL, of length 1, or a length equal to the
number of new categorical variables.}

\item{baseprobs}{A matrix of baseline probabilities. The row values must sum to 1. 
The number of rows represents the number of new categorical variables. The number
of columns represents the number of possible responses - if an particular category
has fewer possible responses, assign zero probability to non-relevant columns.}

\item{prefix}{A string.The names of the new variables will be a concatenation of
the prefix and a sequence of integers indicating the variable number.}

\item{rho}{Correlation coefficient, -1 < rho < 1. Use if corMatrix is not provided.}

\item{corstr}{Correlation structure of the variance-covariance matrix
defined by sigma and rho. Options include "ind" for an independence
structure, "cs" for a compound symmetry structure, and "ar1" for an
autoregressive structure.}

\item{corMatrix}{Correlation matrix can be entered directly. It must be symmetrical 
and positive semi-definite. It is not a required field; if a matrix is not provided, 
then a structure and correlation coefficient rho must be specified.}
}
\value{
Original data.table with added categorical fields
}
\description{
Correlated ordinal categorical data is added to an existing data set.
}
\examples{
#### Set definitions

baseprobs <- matrix(c(0.2, 0.1, 0.1, 0.6,
                      0.7, 0.2, 0.1, 0,
                      0.5, 0.2, 0.3, 0,
                      0.4, 0.2, 0.4, 0,
                      0.6, 0.2, 0.2, 0), 
                    nrow = 5, byrow = TRUE)
                    
set.seed(333)                     
dT <- genData(1000)

dX <- genCorOrdCat(dT, adjVar = NULL, baseprobs = baseprobs, 
                   prefix = "q", rho = .125, corstr = "cs")

dM <- data.table::melt(dX, id.vars = "id")
dProp <- dM[ , prop.table(table(value)), by = variable]
dProp[, response := c(1:4, 1:3, 1:3, 1:3, 1:3)]

data.table::dcast(dProp, variable ~ response, 
                  value.var = "V1", fill = 0)
                   
}
