% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{logisticCoefs}
\alias{logisticCoefs}
\title{Determine intercept, treatment/exposure and covariate coefficients that can 
be used for binary data generation with a logit link and a set of covariates}
\usage{
logisticCoefs(
  defCovar,
  coefs,
  popPrev,
  rr = NULL,
  rd = NULL,
  auc = NULL,
  tolerance = 0.001,
  sampleSize = 1e+05,
  trtName = "A"
)
}
\arguments{
\item{defCovar}{A definition table for the covariates in the underlying
population. This tables specifies the distribution of the covariates.}

\item{coefs}{A vector of coefficients that reflect the relationship between 
each of the covariates and the log-odds of the outcome.}

\item{popPrev}{The target population prevalence of the outcome. 
A value between 0 and 1.}

\item{rr}{The target risk ratio, which must be a value between 0 and
1/popPrev. Defaults to NULL.}

\item{rd}{The target risk difference, which must be between
-(popPrev) and (1 - popPrev). Defaults to NULL}

\item{auc}{The target AUC, which must be a value between 0.5 and 1.0 . 
Defaults to NULL.}

\item{tolerance}{The minimum stopping distance between the adjusted low and high
endpoints. Defaults to 0.001.}

\item{sampleSize}{The number of units to generate for the bisection algorithm. 
The default is 1e+05. To get a reliable estimate, the value 
should be no smaller than the default, though larger values can be used, though
computing time will increase.}

\item{trtName}{If either a risk ratio or risk difference is the target statistic,
a treatment/exposure variable name can be provided. Defaults to "A".}
}
\value{
A vector of parameters including the intercept and covariate 
coefficients for the logistic model data generating process.
}
\description{
This is an implementation of an iterative bisection procedure 
that can be used to determine coefficient values for a target population 
prevalence as well as a target risk ratio, risk difference, or AUC. These 
coefficients can be used in a subsequent data generation process to simulate
data with these desire characteristics.
}
\details{
If no specific target statistic is specified, then only the intercept
is returned along with the original coefficients. Only one target statistic (risk ratio, risk
difference or AUC) can be specified with a single function call; in all three cases, a target
prevalence is still required.
}
\examples{
\dontrun{
d1 <- defData(varname = "x1", formula = 0, variance = 1)
d1 <- defData(d1, varname = "b1", formula = 0.5, dist = "binary")

coefs <- log(c(1.2, 0.8))

logisticCoefs(d1, coefs, popPrev = 0.20) 
logisticCoefs(d1, coefs, popPrev = 0.20, rr = 1.50, trtName = "rx") 
logisticCoefs(d1, coefs, popPrev = 0.20, rd = 0.30, trtName = "rx")
logisticCoefs(d1, coefs, popPrev = 0.20, auc = 0.80)
}
}
\references{
Austin, Peter C. "The iterative bisection procedure: a useful 
tool for determining parameter values in data-generating processes in 
Monte Carlo simulations." BMC Medical Research Methodology 23, 
no. 1 (2023): 1-10.
}
\concept{utility}
