% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst.R
\name{rmst_two_arm}
\alias{rmst_two_arm}
\title{Calculate RMST difference}
\usage{
rmst_two_arm(
  time_var,
  event_var,
  group_var,
  trunc_time,
  reference = sort(unique(group_var))[1],
  alpha = 0.05
)
}
\arguments{
\item{time_var}{A numeric vector of follow up time.}

\item{event_var}{A numeric or integer vector of the status indicator;
0=alive 1=event.}

\item{group_var}{A vector of treatment groups.}

\item{trunc_time}{A numeric vector of pre-defined cut-off time point(s).}

\item{reference}{Group name of reference group for RMST comparison.
Default is the first group name by alphabetical order.}

\item{alpha}{A numeric value of the significant level for RMST
confidence interval. Default is 0.05.}
}
\value{
A list of 2 data frames of RMST calculations:
\itemize{
\item \code{rmst_per_arm}: the calculation results per group.
\item \code{rmst_diff}: the calculation results of RMST differences.
}
}
\description{
Calculate RMST difference
}
\examples{
data(ex1_delayed_effect)
with(
  ex1_delayed_effect,
  simtrial:::rmst_two_arm(
    time_var = month,
    event_var = evntd,
    group_var = trt,
    trunc_time = 6,
    reference = "0",
    alpha = 0.05
  )
)
}
\keyword{internal}
