% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_rw}
\alias{deriv_rw}
\title{Analytic D matrix Random Walk (RW) Process}
\usage{
deriv_rw(tau)
}
\arguments{
\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{matrix} with the first column containing
 the partial derivative with respect to \eqn{\gamma^2}{gamma^2}.
}
\description{
Obtain the first derivative of the Random Walk (RW) process.
}
\section{Process Haar WV First Derivative}{

Taking the derivative with respect to \eqn{\gamma ^2}{gamma^2} yields:
\deqn{ \frac{\partial }{{\partial {\gamma ^2}}}\nu _j^2\left( {{\gamma ^2}} \right) = \frac{{\tau _j^2 + 2}}{{12{\tau _j}}} }{d/dgamma2 nu[j]^2 (gamma2) = (tau[j]^2 + 2)/(12*tau[j])}
}

\author{
James Joseph Balamuta (JJB)
}
