% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourPlot.R
\name{contourPlot}
\alias{contourPlot}
\title{Contour plot of pollutant concentration}
\usage{
contourPlot(
  data,
  domain = NULL,
  background = NULL,
  underlayer = NULL,
  overlayer = NULL,
  legend = NULL,
  levels = NULL,
  size = 0,
  cover = TRUE,
  transparency = 0.66,
  smoothness = 1,
  colors = NULL,
  bare = FALSE
)
}
\arguments{
\item{data}{A dataframe containing data to be plotted in the form of X, Y and
Z (levels).}

\item{domain}{An array with min X, max X, min Y, max Y, number of ticks on X
axis, number of ticks on Y axis (optional).}

\item{background}{String containing the path to the png file to be plotted as
a basemap (optional).}

\item{underlayer}{Array of strings containing layers to be plotted between
basemap and contour plot (optional).}

\item{overlayer}{Array of strings containing layers to be plotted on top of
the contour plot (optional).}

\item{legend}{(string) Legend title (optional).}

\item{levels}{Array of levels for contour plot. If not set, automatic levels
are plotted.}

\item{size}{float with the thickness of the contour line.}

\item{cover}{boolean (default TRUE) to specify whether the contour plot
should be filled or not.}

\item{transparency}{float (between 0 and 1, default=0.66). Transparency level
of the contour plot.}

\item{smoothness}{integer factor to improve the horizontal resolution
(smaller cells) by bilinear interpolation.}

\item{colors}{Color palette for contour plot}

\item{bare}{Boolean (default FALSE) parameter to completely remove axis,
legend, titles and any other graphical element from the plot.}
}
\value{
A \code{ggplot2} plot.
}
\description{
\code{contourPlot} plots a contour map of pollutants.
}
\details{
This is a convenience function to plot contour levels of a pollutant matrix
with \code{ggplot2}.
}
\examples{
\dontrun{
# Load example data in long format
data(volcano)
volcano3d <- reshape2::melt(volcano)
names(volcano3d) <- c("x", "y", "z")
# Contour plot with default options
contourPlot(volcano3d)

# Import variable CONCAN from inpufile, convert km to m (k = 1000):
data <- importRaster(paste0(dir, inputfile), 
                     k = 1000, 
                     variable = "CONCAN")

# Simple contour plot
contourPlot(data)

# Specifiy (sub)domain to be plotted; background image; legend title and 
# pollutant levels.
contourPlot(data, 
            domain(500000, 510000, 6000000, 6010000, 7, 7), 
            background = "img/background.png", 
            legend = "no2 [ug/m3]", 
            levels = c(10, 20, 30, 40))

# Add underlayer (same for overlayer)
library(ggplot2)
library(maptools)
perimetro <- readShapeLines("path_to/perimetro.shp")
perimetro <- fortify(perimetro)
strada <- readShapeLines("path_to/strada.shp")
strada <- fortify(strada)
myUnderlayer <- vector(mode = "list", length = 2)
myUnderlayer[[1]] <- geom_polygon(data = perimetro, 
                                  aes(long, lat, group = group), 
                                  colour = "black", 
                                  fill = NA, 
                                  size = 0.1, 
                                  alpha = 0.5)
myUnderlayer[[2]] <- geom_path(data = strada, 
                               aes(long, lat, group = group), 
                               colour = "grey", 
                               size = 0.1, 
                               alpha = 0.5)
contourPlot(data = test, 
            background = "path_to/basemap.png", 
            underlayer = myUnderlayer)

# Change default colour palette
contourPlot(data = test, 
            colors = RColorBrewer::brewer.pal(3, name = "PiYG"))
}

}
