% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{generate_model}
\alias{generate_model}
\title{Generate a model.}
\usage{
generate_model(object = ".", make_model, ..., seed = 123,
  vary_along = NULL)
}
\arguments{
\item{object}{the name of the directory where directory named "files" exists
(or should be created) to save \code{\linkS4class{Model}} object in.
Default is current working directory. Or can be an object of class
\code{\linkS4class{Simulation}}, in which case the \code{object@dir} is used
and a simulation object is returned instead of an object of class
\code{\linkS4class{ModelRef}}.}

\item{make_model}{a function that outputs an object of class
\code{\linkS4class{Model}}.  Or a list of such functions.}

\item{...}{optional parameters that may be passed to make_model}

\item{seed}{an integer seed for the random number generator.}

\item{vary_along}{character vector with all elements contained in names(...)
See description for more details.}
}
\description{
This function executes the \code{make_model} function provided by the user
and writes to file the resulting \code{\linkS4class{Model}} object(s).  For example,
when simulating regression with a fixed design, \code{X} would be generated
in this function and \code{n}, \code{p}, \code{beta}, and \code{sigma} would
also be specified.
}
\details{
When \code{make_model} has arguments, these can be passed using \code{...}.
These will be passed directly to \code{make_model} except for any arguments
named in \code{vary_along}.  These arguments should be lists and a separate
model will be created for each combination of elements in these lists.  For
example, if \code{vary_along = c("n", "p")}, then we can pass
\code{n=as.list(c(50, 100, 150))} and \code{p=as.list(c(10, 100))} and 6
models will be created, one for each pair of \code{n} and \code{p}.  For each
pair (n,p), a distinct extension is added to the end of the model name. This
extension is generated using a hash function so that different values of the
vary_along parameters will lead to different model name extensions. This
ensures that if one later decides to add more values of the vary_along
parameters, this will not lead to pre-existing files being overwritten
(unless the same values of the vary_along combination are used again.

If \code{object} is a directory name, the function returns a reference or
list of references to the model(s) generated. If \code{object} is a
\code{Simulation}, then function returns the same \code{Simulation} object
but with references added to the new models created.  These changes to the
\code{Simulation} object are saved to file.

\code{make_model} is called generating an object of class
\code{\linkS4class{Model}}, called \code{model}, which is saved to
\code{dir/name/model.Rdata} (where \code{name} is the name attribute of
\code{model}). This file also contains the random number generator state and
other information such as the function \code{make_model} itself and the date
when \code{model} was created.
}
\examples{
 # initialize a new simulation
 sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir())
 # generate a model (and add it to the simulation)
 sim <- generate_model(sim, make_my_example_model, n = 20)
 # generate a sequence of models (and add them to the simulation)
 sim <- generate_model(sim, make_my_example_model,
                       n = list(10, 20, 30),
                       vary_along = "n")
}
\seealso{
\code{\link{new_model}} \code{\link{simulate_from_model}}
\code{\link{run_method}}
}

