% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\name{new_model}
\alias{new_model}
\title{Create a Model object}
\usage{
new_model(name, label, params = list(), simulate)
}
\arguments{
\item{name}{a short name identifier.  Must be alphanumeric (though -, _, and
/ are allowed as long as they are not at the start or end of name.}

\item{label}{a longer, human readable label that can have other characters
such as spaces, hyphens, etc.}

\item{params}{a list that contains the Model object's parameters}

\item{simulate}{a function that has arguments \code{nsim} and names
matching elements within \code{names(params)}. It returns a list of
length nsim, where each element of the list represents a random draw
from the \code{Model} object.}
}
\description{
Creates a new \code{\linkS4class{Model}} object.
}
\examples{
make_my_example_model <- function(n) {
  new_model(name = "normal-data",
            label = sprintf("Normal (n = \%s)", n),
            params = list(n = n, mu = 2),
            simulate = function(n, mu, nsim) {
              # this function must return a list of length nsim
              x <- matrix(rnorm(n * nsim), n, nsim)
              x <- mu + x # true mean is mu
              return(split(x, col(x))) # make each col its own list element
            })
}
}

