\name{modelfit.sirt}
\alias{modelfit.sirt}
\title{
Model Fit of Item Response Models
}
\description{
This function calculates a statistic of global model fit while
comparing observed and expected item pair correlations.
}
\usage{
modelfit.sirt(object)
}
\arguments{
  \item{object}{
An object generated by \code{\link{rasch.mml2}},
\code{\link{rasch.mirtlc}}, \code{\link{rasch.pml2}}, \code{\link{rasch.pml3}},
\code{\link{smirt}}
}
}
\value{
A list with following entries:
  \item{modelfit}{Model fit statistics: \cr
   \code{MADcor}: mean of absolute deviations in observed and expected correlations 
        (DiBello et al., 2007)  \cr
    \code{MX2}: Mean of \eqn{\chi^2} statistics of all item pairs 
    		(Chen & Thissen, 1997) \cr
    \code{MADRESIDCOV}: Mean of absolute deviations of residual 
    		covariances (McDonald & Mok, 1995) \cr
    \code{MADQ3}: Mean of absolute values of \eqn{Q_3} statistic (Yen, 1984)
            }
  \item{itempairs}{Fit of every item pair} 
}
\references{
Chen, W., & Thissen, D. (1997). Local dependence indexes for item pairs 
 using item response theory. \emph{Journal of Educational and Behavioral Statistics},
 \bold{22}, 265-289.

  DiBello, L. V., Roussos, L. A., & Stout, W. F. (2007) Review of
  cognitively diagnostic assessment and a summary of psychometric models.
  In C. R. Rao and S. Sinharay (Eds.), \emph{Handbook of Statistics},
  Vol. 26 (pp. 979--1030). Amsterdam: Elsevier.

  McDonald, R. P., & Mok, M. M.-C. (1995). Goodness of fit in item response models.
  \emph{Multivariate Behavioral Research}, \bold{30}, 23-40.

Yen, W. M. (1984). Effects of local item dependence on the fit and equating 
performance of the three-parameter logistic model. 
\emph{Applied Psychological Measurement}, \bold{8}, 125-145.
}
\author{
Alexander Robitzsch
}
%\note{
%%  ~~further notes~~
%}

\seealso{
Supported classes: \code{\link{rasch.mml2}},
\code{\link{rasch.mirtlc}}, \code{\link{rasch.pml2}}, \code{\link{rasch.pml3}},
\code{\link{smirt}}
 }

\examples{
\dontrun{	
#############################################################################
# EXAMPLE 1: Reading data
#############################################################################
data(data.read)
dat <- data.read
I <- ncol(dat)

# Rasch model
mod1 <- rasch.mml2( dat  )
# Rasch model with smoothed distribution
mod2 <- rasch.mml2( dat , distribution.trait="smooth3" )
# 2PL model
mod3 <- rasch.mml2( dat , distribution.trait="normal" , est.a=1:I )
# 3PL model with equal guessing parameter
mod4 <- rasch.mml2( dat, distribution.trait="smooth3", est.a=1:I, est.c=rep(1,I) )
# Latent class model with 2 classes
mod5 <- rasch.mirtlc( dat , Nclasses=2 )
# Rasch latent class model with 3 classes
mod6 <- rasch.mirtlc( dat , Nclasses=3 , modeltype="MLC1", mmliter=100)

# PML estimation
mod7 <- rasch.pml3( dat )
# Model 8: PML estimation
# Modelling error correlations: 
#          joint residual correlations for each item cluster
error.corr <- diag(1,ncol(dat))
itemcluster <- rep( 1:4 ,each=3 )
for ( ii in 1:3){
    ind.ii <- which( itemcluster == ii )
    error.corr[ ind.ii , ind.ii ] <- ii
        }
mod8 <- rasch.pml3( dat , error.corr = error.corr )

# 1PL in smirt
Qmatrix <- matrix( 1 , nrow=I , ncol=1 )
mod9 <- smirt( dat , Qmatrix=Qmatrix )

# compare model fit
a1 <- modelfit.sirt(mod1)
a2 <- modelfit.sirt(mod2)
a3 <- modelfit.sirt(mod3)
a4 <- modelfit.sirt(mod4)
a5 <- modelfit.sirt(mod5)
a6 <- modelfit.sirt(mod6)
a7 <- modelfit.sirt(mod7)
a8 <- modelfit.sirt(mod8)
a9 <- modelfit.sirt(mod9)}
}
\keyword{Model fit}

