% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_check.R
\name{check_functions}
\alias{check_functions}
\alias{.check_set_caller}
\alias{.check_identify_caller}
\alias{.check_that}
\alias{.check_null}
\alias{.check_na}
\alias{.check_require_packages}
\alias{.check_names}
\alias{.check_length}
\alias{.check_apply}
\alias{.check_lgl_type}
\alias{.check_num_type}
\alias{.check_chr_type}
\alias{.check_lst_type}
\alias{.check_lgl}
\alias{.check_num}
\alias{.check_chr}
\alias{.check_lst}
\alias{.check_chr_within}
\alias{.check_chr_contains}
\alias{.check_file}
\alias{.check_env_var}
\alias{.check_warn}
\alias{.check_error}
\alias{.check_documentation}
\title{Check functions}
\usage{
.check_set_caller(caller)

.check_identify_caller()

.check_that(x, ..., local_msg = NULL, msg = NULL)

.check_null(x, ..., msg = NULL)

.check_na(x, ..., allow_na = FALSE, msg = NULL)

.check_require_packages(x, ..., msg = "Please install package(s)")

.check_names(x, ..., is_named = TRUE, msg = NULL)

.check_length(x, ..., len_min = 0, len_max = 2^31 - 1, msg = NULL)

.check_apply(x, fn_check, ...)

.check_lgl_type(x, ..., msg = NULL)

.check_num_type(x, ..., is_integer = FALSE, msg = NULL)

.check_chr_type(x, ..., msg = NULL)

.check_lst_type(x, ..., msg = NULL)

.check_lgl(
  x,
  ...,
  allow_na = FALSE,
  len_min = 0,
  len_max = 2^31 - 1,
  allow_null = FALSE,
  is_named = FALSE,
  msg = NULL
)

.check_num(
  x,
  ...,
  allow_na = FALSE,
  min = -Inf,
  max = Inf,
  exclusive_min = -Inf,
  exclusive_max = Inf,
  len_min = 0,
  len_max = 2^31 - 1,
  allow_null = FALSE,
  is_integer = FALSE,
  is_named = FALSE,
  tolerance = 0,
  msg = NULL
)

.check_chr(
  x,
  ...,
  allow_na = FALSE,
  allow_empty = TRUE,
  len_min = 0,
  len_max = 2^31 - 1,
  allow_null = FALSE,
  is_named = FALSE,
  regex = NULL,
  msg = NULL
)

.check_lst(
  x,
  ...,
  min_len = 0,
  max_len = 2^31 - 1,
  allow_null = FALSE,
  is_named = TRUE,
  fn_check = NULL,
  msg = NULL
)

.check_chr_within(
  x,
  within,
  ...,
  case_sensitive = TRUE,
  discriminator = "all_of",
  can_repeat = TRUE,
  msg = NULL
)

.check_chr_contains(
  x,
  contains,
  ...,
  case_sensitive = TRUE,
  discriminator = "all_of",
  can_repeat = TRUE,
  msg = NULL
)

.check_file(x, ..., extensions = NULL, msg = NULL)

.check_env_var(x, ..., msg = NULL)

.check_warn(expr)

.check_error(expr, ..., msg = NULL)

.check_documentation(progress)
}
\arguments{
\item{caller}{A \code{character} value with the caller name.}

\item{x}{Any object that will be evaluated.}

\item{...}{Additional parameters for \code{fn_check} function.}

\item{local_msg}{A \code{character} with the generic error message that
will be shown inside parenthesis.}

\item{msg}{A \code{character} with the error message that will be
shown as the main message to the user.}

\item{allow_na}{A \code{logical} indicating if the check permits empty
NA values. Default is FALSE.}

\item{is_named}{A \code{logical} indicating if the check permits unnamed
list.}

\item{len_min}{A \code{numeric} indicating the minimum length of vector
or list users provides for functions. Default is \code{0}.}

\item{len_max}{A \code{numeric} indicating the maximum length of vector
or list users provides for functions. Default is \code{2^31}.}

\item{fn_check}{A \code{function} used to test each element of an
object.}

\item{is_integer}{A \code{logical} indicating if the value should be
integer.}

\item{allow_null}{A \code{logical} indicating if the check permits empty
NULL values. Default is FALSE.}

\item{min}{A atomic \code{vector} of numeric indicating the
inclusive minimum value that the user can provide in function parameter.
Only works for numeric check. By default it is \code{-Inf}.}

\item{max}{A atomic \code{vector} of numeric indicating the
inclusive maximum value that the user can provide in function parameter.
Only works for numeric check. By default it is \code{Inf}.}

\item{exclusive_min}{A atomic \code{vector} of numeric indicating the
exclusive minimum value that the user can provide in function parameter.
Only works for numeric check. By default it is \code{-Inf}.}

\item{exclusive_max}{A atomic \code{vector} of numeric indicating the
exclusive maximum value that the user can provide in function parameter.
Only works for numeric check. By default it is \code{Inf}.}

\item{tolerance}{A \code{numeric} with the tolerance to be
accepted in range test. The default value is NULL.}

\item{allow_empty}{A \code{logical} indicating if the check permits empty
list. Default is TRUE.}

\item{regex}{A \code{character} value with regular expression to be
evaluated against data.}

\item{min_len}{A \code{numeric} indicating the minimum length of vector
or list users provides for functions. Default is \code{0}.}

\item{max_len}{A \code{numeric} indicating the maximum length of vector
or list users provides for functions. Default is \code{2^31}.}

\item{within}{A \code{character} vector indicating a set of elements
from which \code{x} is a kind of subset. The actual behavior is pointed by
\code{discriminator} parameter.}

\item{case_sensitive}{A \code{logical} indicating if the check is compared
with case sensitive. Default is \code{TRUE}.}

\item{discriminator}{A \code{character} value indicating how subset
verification will be done (see details).}

\item{can_repeat}{A \code{logical} value indicating if vector \code{x}
can have repeated elements or not.}

\item{contains}{A \code{character} vector indicating a set of elements
to which \code{x} is a kind of superset. The actual behavior is pointed by
\code{discriminator} parameter.}

\item{extensions}{A \code{character} vector with all allowed file
extensions.}

\item{expr}{A R \code{expression} to be evaluated.}

\item{show_pks_name}{A \code{logical} value indicating if
uninstalled packages can be shown.}
}
\value{
Unless otherwise specified, all checking functions return the same
argument as \code{x} if a \code{TRUE} evaluation occurs.

\code{.check_set_caller()} returns \code{NULL}.

\code{.check_identify_caller()} returns a \code{character} value.

The same input value if no error occurs
}
\description{
Functions used to check parameters in a systematic way.
}
\details{
Error message functions:
\itemize{
\item{\code{.check_set_caller()} should be used to set the caller name
that appears in error messages. Any error raised by a check function
will show the caller function in its error message. The caller name will
be determined by the last call to this function before error occurs.
If no call was made, the first function in the calling stack will be
used.
}
\item{\code{.check_identify_caller()} searches for the caller
name to be shown in error messages. The function searches in calling stack
if a call to \code{check_set_caller()} was made and returns its value. If
no call was found, it returns the first function in calling stack.
}
}

General check functions:
\itemize{
\item{
\code{.check_that()} function checks if the argument in
\code{x} is \code{logical} or not. If it is \code{logical}, it will be
evaluated as \code{TRUE} if all values are \code{TRUE}, \code{FALSE}
otherwise. If the argument is not \code{logical}, it will be evaluated
as \code{TRUE} if its length is greater than zero,
\code{FALSE} otherwise. If a \code{FALSE} evaluation occurs, an error
will be raised.
}
\item{
\code{.check_null()} throws an error if \code{x} argument
is \code{NULL}.
}
\item{
\code{.check_na()} throws an error if any element of \code{x}
is \code{NA}.
}
\item{
\code{.check_names()} throws an error if \code{x} does not have
names and \code{is_named} argument is \code{TRUE} (and vice-versa). This
function checks for empty or duplicated names if \code{is_named} is
\code{TRUE}.
}
\item{
\code{.check_length()} throws an error if length of \code{x}
is out of the range specified by \code{len_min} and \code{len_max}
(both inclusive).
}
\item{
\code{.check_apply()} throws an error only if \code{fn_check}
function throws an error when applied to each \code{x} element.
}
}

Check type functions:
\itemize{
\item{
\code{.check_lgl_type()} throws an error if \code{x} type is not
\code{logical}.
}
\item{
\code{.check_num_type()} throws an error if \code{x}
type is not \code{numeric}. Also, an error will be throw if \code{x} values
are not \code{integer} and \code{is_integer} parameter is \code{TRUE}.
}
\item{
\code{.check_int_type()} throws an error if \code{x}
type is not \code{numeric} with integer values.
}
\item{
\code{.check_chr_type()} throws an error if \code{x}
type is not \code{character}.
}
\item{
\code{.check_lst_type()} throws an error if \code{x}
type is not \code{list}.
}
}

Combined check functions. These function combine some checks mentioned
above in one place. In general, these functions can check for \code{NA}
(if \code{allow_na=FALSE}), for value length (if either \code{len_min}
and \code{len_max} are defined - for \code{list} the parameters are
\code{min_len} and \code{max_len}, respectively), for \code{NULL} value
(if \code{allow_null=FALSE}), and for names (if \code{is_named} is
\code{TRUE} or \code{FALSE}). Depending on specific type, the functions
also check for:

\itemize{
\item{
\code{.check_lgl()} checks for \code{logical} values.
}
\item{
\code{.check_num()} checks for \code{numeric} values and its range (if
either \code{min}, \code{max}, \code{exclusive_min}, or \code{exclusive_max}
parameters are defined). It also checks \code{integer} values
(if \code{is_integer=TRUE}).
}
\item{
\code{.check_chr()} checks for \code{character} type and empty strings (if
\code{allow_empty=FALSE}). It also checks strings through regular
expression (if \code{regex} parameter is defined).
}
\item{
\code{.check_lst()} checks for \code{list} type. By default, it checks if
the list is named. Additionally, a function can be passed to
\code{fn_check} parameter to check its elements. This enables to pass
other checking functions like \code{.check_num()} to verify the type of
its elements. In this case, extra parameters can be passed by \code{...}.
}
}

Subset check functions. Two functions are provided to check for
subset elements in \code{character} vectors. These functions are the
symmetrical equivalent to each other, but the error messages are different.
For the \code{.check_chr_within()}, the error message focus on the
\code{within} values. For the \code{.check_chr_contains()}, the error
message focus on the \code{contains} values. The verification is done
accordingly to the \code{discriminator} parameter, that can be:
\code{one_of}, \code{any_of}, \code{all_of}, \code{none_of}, or
\code{exactly}.

\itemize{
\item{
\code{.check_chr_within()} throws an error if provided \code{within} vector
does not correspond to the \code{discriminator} with respect to \code{x}
parameter (e.g. "one of x within...", "all of x within...).
\code{one_of}: only one value (can it repeat?) of \code{x} appears
in \code{within} vector. \code{any_of}: at least one value (can it
repeat?) of \code{x} appears in \code{within} vector. \code{all_of}
(default): all values (can it repeat?) of \code{x} appears in \code{within}
vector. \code{none_of}: no value of \code{x} is in \code{within} vector.
\code{exactly}: value of \code{x} (can it repeat?) is equal to
\code{within} vector.
}
\item{
\code{.check_chr_contains()} throws an error if provided \code{x}
vector does not correspond to the \code{discriminator} with respect to
\code{contains} parameter (e.g. "x contains one of...",
"x contains all of..."). \code{one_of}: only one value (can it repeat?) of
\code{contains} appears in \code{x} vector. \code{any_of}: at least one
value (can it repeat?) of \code{contains} appears in \code{x} vector.
\code{all_of} (default): all values (can it repeat?) of \code{contains}
appears in \code{x} vector. \code{none_of}: no value of \code{contains} is
in \code{x} vector. \code{exactly}: value of \code{contains} is exactly
(can it repeat?) equal to \code{x}.
}
}

Special checking function:

\itemize{
\item{
\code{.check_file()} throws an error if provided value is not a valid and
existing file path.
}
}

Special checking function:

\itemize{
\item{
\code{.check_env_var()} throws an error if provided environment variable is
not existing.
}
}

Contextual check and error conversion functions:

\itemize{
\item{
\code{.check_warn()} converts an error raised by an R expression in
\code{expr} parameter into a warning message.
}
\item{
\code{.check_error()} captures any error raised by an R expression in
\code{expr} parameter, and shows a personalized message.
}
}
}
\keyword{internal}
