% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_uncertainty.R
\name{sits_uncertainty}
\alias{sits_uncertainty}
\alias{sits_uncertainty.probs_cube}
\alias{sits_uncertainty.probs_vector_cube}
\alias{sits_uncertainty.raster_cube}
\alias{sits_uncertainty.default}
\title{Estimate classification uncertainty based on probs cube}
\usage{
sits_uncertainty(cube, ...)

\method{sits_uncertainty}{probs_cube}(
  cube,
  ...,
  type = "entropy",
  multicores = 2L,
  memsize = 4L,
  output_dir,
  version = "v1",
  progress = TRUE
)

\method{sits_uncertainty}{probs_vector_cube}(
  cube,
  ...,
  type = "entropy",
  multicores = 2L,
  memsize = 4L,
  output_dir,
  version = "v1"
)

\method{sits_uncertainty}{raster_cube}(cube, ...)

\method{sits_uncertainty}{default}(cube, ...)
}
\arguments{
\item{cube}{Probability data cube.}

\item{...}{Other parameters for specific functions.}

\item{type}{Method to measure uncertainty. See details.}

\item{multicores}{Number of cores to run the function.}

\item{memsize}{Maximum overall memory (in GB) to run the function.}

\item{output_dir}{Output directory for image files.}

\item{version}{Version of resulting image (in the case of
multiple tests).}

\item{progress}{Check progress bar?}
}
\value{
An uncertainty data cube
}
\description{
Calculate the uncertainty cube based on the probabilities
produced by the classifier. Takes a \code{probability cube} as input and
produces a \code{uncertainty cube}.
}
\note{
The output of \code{\link[sits]{sits_classify}} and
\code{\link[sits]{sits_smooth}} is a \code{probability cube} containing
the class probability for all pixels, which are generated by the
machine learning model. The \code{sits_uncertainty} function takes
a \code{probability cube} and produces a \code{uncertainty code} which
contains a measure of uncertainty for each pixel, based on the
class probabilities.

The uncertainty measure is relevant in the context of active leaning,
and helps to increase the quantity and quality of training samples by
providing information about the confidence of the model.

The supported types of uncertainty are:
\enumerate{
\item{\code{entropy}: the difference between all predictions expressed a
Shannon measure of entropy.}
\item{\code{least}: the difference between 1.0 and most confident
prediction.}
\item{\code{margin}: the difference between the two most confident
predictions.}
}
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # calculate uncertainty
    uncert_cube <- sits_uncertainty(probs_cube, output_dir = tempdir())
    # plot the resulting uncertainty cube
    plot(uncert_cube)
}
}
\references{
Monarch, Robert Munro. Human-in-the-Loop Machine Learning:
Active learning and annotation for human-centered AI. Simon and Schuster,
2021.
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolfsimoes@gmail.com}

Alber Sanchez, \email{alber.ipia@inpe.br}
}
