% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_variance.R
\name{sits_variance}
\alias{sits_variance}
\alias{sits_variance.probs_cube}
\alias{sits_variance.raster_cube}
\alias{sits_variance.derived_cube}
\alias{sits_variance.default}
\title{Calculate the variance of a probability cube}
\usage{
sits_variance(cube, ...)

\method{sits_variance}{probs_cube}(
  cube,
  ...,
  window_size = 9L,
  neigh_fraction = 0.5,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1",
  progress = TRUE
)

\method{sits_variance}{raster_cube}(cube, ...)

\method{sits_variance}{derived_cube}(cube, ...)

\method{sits_variance}{default}(cube, ...)
}
\arguments{
\item{cube}{Probability data cube (class "probs_cube")}

\item{...}{Parameters for specific functions}

\item{window_size}{Size of the neighborhood (odd integer)}

\item{neigh_fraction}{Fraction of neighbors with highest probability
for Bayesian inference (numeric from 0.0 to 1.0)}

\item{memsize}{Maximum overall memory (in GB) to run the
smoothing (integer, min = 1, max = 16384)}

\item{multicores}{Number of cores to run the smoothing function
(integer, min = 1, max = 2048)}

\item{output_dir}{Output directory for image files
(character vector of length 1)}

\item{version}{Version of resulting image
(character vector of length 1)}

\item{progress}{Check progress bar?}
}
\value{
A variance data cube.
}
\description{
Takes a probability cube and estimate the local variance
             of the logit of the probability,
             to support the choice of parameters for Bayesian smoothing.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    var_cube <- sits_variance(probs_cube, output_dir = tempdir())
    # plot the variance cube
    plot(var_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolfsimoes@gmail.com}
}
