% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{obtener_nombre_dpto}
\alias{obtener_nombre_dpto}
\title{Obtener el nombre de un departamento de Colombia}
\usage{
obtener_nombre_dpto(data_geo, cod_dpto)
}
\arguments{
\item{data_geo}{Un `data.frame` que contiene los códigos
geográficos (departamentos y municipios de Colombia).}

\item{cod_dpto}{Un `numeric` (numérico) o `character`
(cadena de caracteres) que contiene el código
del departamento.}
}
\value{
Un `character` (cadena de caracteres) con el nombre del
departamento.
}
\description{
Función que obtiene el nombre de un departamento de
Colombia a partir de su código geográfico.
}
\examples{
data_geo <- import_geo_cods()
obtener_nombre_dpto(data_geo,
  cod_dpto = "05"
)
obtener_nombre_dpto(data_geo,
  cod_dpto = 05
)
obtener_nombre_dpto(data_geo,
  cod_dpto = 5
)
}
