% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_data_event}
\alias{import_data_event}
\title{Importar los datos de una enfermedad o evento por año
desde los microdatos del SIVIGILA}
\usage{
import_data_event(nombre_event, years, ruta_dir = NULL, cache = FALSE)
}
\arguments{
\item{nombre_event}{Un `character` (cadena de caracteres) con el nombre de
la enfermedad o evento.}

\item{years}{Un `numeric` (numérico) con el año o años deseado(s) para
la descarga de los datos.}

\item{ruta_dir}{Un `character` (cadena de caracteres) que contiene la ruta
del directorio donde se almacenarán los datos del evento o enfermedad.
Su valor por defecto es `NULL`.}

\item{cache}{Un `logical` (`TRUE` o `FALSE`) que indica si los datos
descargados deben ser almacenados en caché. Su valor por defecto
es `FALSE`.}
}
\value{
Un `data.frame` con los datos del año de la enfermedad o evento
seleccionado desde los microdatos del SIVIGILA.
}
\description{
Función que importa los datos de una enfermedad o evento por
año desde los microdatos del SIVIGILA.
}
\examples{
\donttest{
if (interactive()) {
import_data_event(nombre_event = "DENGUE",
                  years = 2020,
                  cache = TRUE)
import_data_event(nombre_event = "CHAGAS",
                  years = c(2019, 2020),
                  ruta_dir = tempdir())
import_data_event(nombre_event = "CHAGAS",
                  years = seq(2018, 2020),
                  cache = TRUE)
 }
}
}
