% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sjp.xtab}
\alias{sjp.xtab}
\title{Plot contingency tables}
\usage{
sjp.xtab(y, x, title = "", legendTitle = NULL, weightBy = NULL,
  weightByTitleString = NULL, type = "bars", tableIndex = "col",
  reverseOrder = FALSE, maxYlim = TRUE, upperYlim = NULL,
  axisLabels.x = NULL, legendLabels = NULL, labelPos = "outside",
  stringTotal = "Total", breakTitleAt = 50, breakLabelsAt = 15,
  breakLegendTitleAt = 20, breakLegendLabelsAt = 20, gridBreaksAt = 0.2,
  geom.size = 0.7, geom.spacing = 0.1, geom.colors = "Paired",
  barPosition = "dodge", lineDotSize = 3, smoothLines = FALSE,
  expand.grid = FALSE, showValueLabels = TRUE, jitterValueLabels = FALSE,
  showCategoryLabels = TRUE, showTableSummary = TRUE,
  tableSummaryPos = "r", showTotalColumn = TRUE, hideLegend = FALSE,
  axisTitle.x = NULL, axisTitle.y = NULL, coord.flip = FALSE,
  printPlot = TRUE)
}
\arguments{
\item{y}{The variable which proportions (percentage values) should be plotted. The percentage proportion
(within table row, table column or complete table, see parameter \code{tableIndex} of this variable
are along the y-axis, the variable's categories on the x-axis.}

\item{x}{The grouping variable, where each value represents a single bar chart within each category of
the \code{y} variable.}

\item{title}{Title of the diagram, plotted above the whole diagram panel.
Use \code{"auto"} to automatically detect variable names that will be used as title
(see \code{\link{sji.setVariableLabels}}) for details).}

\item{legendTitle}{Title of the diagram's legend.}

\item{weightBy}{A weight factor that will be applied to weight all cases from \code{y}.}

\item{weightByTitleString}{If a weight factor is supplied via the parameter \code{weightBy}, the diagram's title
may indicate this with a remark. Default is \code{NULL}, so the diagram's title will not be modified when
cases are weighted. Use a string as parameter, e.g.: \code{weightByTitleString=" (weighted)"}.}

\item{type}{The plot type. may be either \code{"b"}, \code{"bar"}, \code{"bars"} (default) for bar charts,
or \code{"l"}, \code{"line"}, \code{"lines"} for line diagram.}

\item{tableIndex}{Indicates which data from the proportional table should be plotted. Use \code{"row"} for
calculating row percentages, \code{"col"} for column percentages and \code{"cell"} for cell percentages.
Only when \code{tableIndex} is \code{"col"}, an additional bar chart with the total sum of each column (i.e.
of each category on the x-axis) can be added with the parameter \code{showTotalColumn}.}

\item{reverseOrder}{Whether the categories along the x-axis should apper in reversed order or not.}

\item{maxYlim}{Indicates how to calculate the maximum limit of the y-axis.
If \code{TRUE}, the y-axes ranges from 0 to 100%.
If \code{FALSE}, the maximum y-axis depends on the highest percentage value of a
variable's answer category. In this case, the y-axis breaks may change,
depending on the variable.}

\item{upperYlim}{Uses a pre-defined upper limit for the y-axis. Overrides the \code{maxYlim} parameter.}

\item{axisLabels.x}{Labels for the x-axis breaks.}

\item{legendLabels}{Labels for the guide/legend.}

\item{labelPos}{Positioning of value labels. If \code{barPosition} is \code{dodge}
(default), use either \code{"inside"} or \code{"outside"} (default) to put labels in-
or outside the bars. You may specify initial letter only. Use \code{"center"}
to center labels (useful if label angle is changes via \code{\link{sjp.setTheme}}).}

\item{stringTotal}{The string for the legend label when a total-column is added. Only applies
if \code{showTotalColumn} is \code{TRUE}. Default is \code{"Total"}.}

\item{breakTitleAt}{Wordwrap for diagram title. Determines how many chars of the title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{Wordwrap for diagram labels. Determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{Wordwrap for diagram legend title. Determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{Wordwrap for diagram legend labels. Determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{gridBreaksAt}{Sets the breaks on the y axis, i.e. at every n'th position a major
grid is being printed. Valid values range from 0 to 1.}

\item{geom.size}{size resp. width of the geoms (bar width).}

\item{geom.spacing}{the spacing between geoms (i.e. bar spacing)}

\item{geom.colors}{User defined color palette for geoms. If specified, must either be vector with color values
of same length as groups defined in \code{x}, or a specific color palette code (see below).
\itemize{
  \item If not specified, the qualitative \code{"Paired"} color brewer palette will be used.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{geom.colors} is any valid color brewer palette name, the related \href{http://colorbrewer2.org}{color brewer} palette will be used. Use \code{display.brewer.all()} from the \code{RColorBrewer} package to view all available palette names.
}
Else specify your own color values as vector (e.g. \code{geom.colors=c("#f00000", "#00ff00", "#0080ff")}).}

\item{barPosition}{Indicates whether bars should be positioned side-by-side (default, or use \code{"dodge"} as
parameter) or stacked (use \code{"stack"} as parameter).}

\item{lineDotSize}{Size of dots. Only applies, when parameter \code{type}
is set to \code{"lines"}.}

\item{smoothLines}{Prints a smooth line curve. Only applies, when parameter \code{type}
is set to \code{"lines"}.}

\item{expand.grid}{If \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{showValueLabels}{Whether counts and percentage values should be plotted to each bar}

\item{jitterValueLabels}{If \code{TRUE}, the value labels on the bars will be "jittered", i.e. they have
alternating vertical positions to avoid overlapping of labels in case bars are
very short. Default is \code{FALSE}.}

\item{showCategoryLabels}{Whether x axis text (category names) should be shown or not.}

\item{showTableSummary}{If \code{TRUE} (default), a summary of the cross tabulation with N, Chi-square (see \code{\link{chisq.test}}),
df, Cramer's V or Phi-value and p-value is printed to the upper right corner of the diagram. If a cell contains expected
values lower than five (or lower than 10 if df is 1),
the Fisher's excact test (see \code{\link{fisher.test}}) is computed instead of Chi-square test.
If the table's matrix is larger than 2x2, Fisher's excact test with Monte Carlo simulation is computed.
Only applies to bar-charts or dot-plots, i.e. when parameter \code{type} is either \code{"bars"} or \code{"dots"}.}

\item{tableSummaryPos}{Position of the model summary which is printed when \code{showTableSummary} is \code{TRUE}. Default is
\code{"r"}, i.e. it's printed to the upper right corner. Use \code{"l"} for upper left corner.}

\item{showTotalColumn}{if \code{tableIndex} is \code{"col"}, an additional bar chart with the sum within each category and
it's percentages will be added to each category.}

\item{hideLegend}{Indicates whether legend (guide) should be shown or not. Default is \code{FALSE}, thus
the legend is shown.}

\item{axisTitle.x}{A label for the x axis. useful when plotting histograms with metric scales where no category labels
are assigned to the x axis.
Use \code{"auto"} to automatically detect variable names that will be used as title
(see \code{\link{sji.setVariableLabels}}) for details).}

\item{axisTitle.y}{A label for the y axis. useful when plotting histograms with metric scales where no category labels
are assigned to the y axis.}

\item{coord.flip}{If \code{TRUE}, the x and y axis are swapped.}

\item{printPlot}{If \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot proportional crosstables (contingency tables) of two variables as ggplot diagram.
}
\examples{
# create 4-category-items
x <- sample(1:4, 100, replace=TRUE)
# create 3-category-items
y <- sample(1:3, 100, replace=TRUE)

# plot "cross tablulation" of x and y
sjp.xtab(y,x)

# plot "cross tablulation" of x and y, including labels
sjp.xtab(y, x,
         axisLabels.x = c("low", "mid", "high"),
         legendLabels = c("Grp 1", "Grp 2", "Grp 3", "Grp 4"))

# plot "cross tablulation" of x and y
# as stacked proportional bars
sjp.xtab(y, x,
         tableIndex = "row",
         barPosition = "stack",
         coord.flip = TRUE)

# example with vertical labels
data(efc)
sjp.setTheme(geom.label.angle = 90)
# hjust-aes needs adjustment for this
library(ggplot2)
update_geom_defaults('text', list(hjust = -0.1))
sjp.xtab(efc$e42dep,
         efc$e16sex,
         showTableSummary = FALSE,
         labelPos = "center")

# grouped bars with EUROFAMCARE sample dataset
# dataset was importet from an SPSS-file, using:
# efc <- sji.SPSS("efc.sav", enc="UTF-8")
data(efc)
efc.val <- sji.getValueLabels(efc)
efc.var <- sji.getVariableLabels(efc)

sjp.xtab(efc$e42dep,
         efc$e16sex,
         title=efc.var['e42dep'],
         axisLabels.x=efc.val[['e42dep']],
         legendTitle=efc.var['e16sex'],
         legendLabels=efc.val[['e16sex']])

sjp.xtab(efc$e16sex,
         efc$e42dep,
         title=efc.var['e16sex'],
         axisLabels.x=efc.val[['e16sex']],
         legendTitle=efc.var['e42dep'],
         legendLabels=efc.val[['e42dep']])

sjp.xtab(efc$e16sex,
         efc$e42dep,
         title=efc.var['e16sex'],
         axisLabels.x=efc.val[['e16sex']],
         legendTitle=efc.var['e42dep'],
         legendLabels=efc.val[['e42dep']],
         tableIndex="row",
         barPosition="stack",
         coord.flip=TRUE,
         jitterValueLabels=TRUE)

# -------------------------------
# auto-detection of labels
# -------------------------------
efc <- sji.setVariableLabels(efc, efc.var)
sjp.xtab(efc$e16sex, efc$e42dep)
}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjp.xtab}{sjPlot manual: sjp.xtab}
             \item \code{\link{sjt.xtab}}
             }
}

