% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotOdds.R
\name{sjp.glm}
\alias{sjp.glm}
\title{Plot odds ratios or predicted probabilities of generalized linear models}
\usage{
sjp.glm(fit, type = "dots", sortOdds = TRUE, title = NULL,
  axisLabels.y = NULL, axisTitle.x = "Odds Ratios", axisLimits = NULL,
  breakTitleAt = 50, breakLabelsAt = 25, gridBreaksAt = 0.5,
  transformTicks = TRUE, geom.size = NULL, geom.colors = "Set1",
  hideErrorBars = FALSE, interceptLineType = 2,
  interceptLineColor = "grey70", remove.estimates = NULL,
  coord.flip = TRUE, showIntercept = FALSE, showAxisLabels.y = TRUE,
  showValueLabels = TRUE, labelDigits = 2, showPValueLabels = TRUE,
  showModelSummary = FALSE, facet.grid = TRUE, show.se = FALSE,
  showOriginalModelOnly = TRUE, printPlot = TRUE)
}
\arguments{
\item{fit}{fitted generalized linear model (\code{\link{glm}}- or \code{logistf}-object).}

\item{type}{type of plot. Use one of following:
\describe{
  \item{\code{"dots"}}{(or \code{"glm"} or \code{"or"} (default)) for odds ratios (forest plot)}
  \item{\code{"bars"}}{for odds ratios as bar plot}
  \item{\code{"prob"}}{(or \code{"pc"}) to plot predicted probabilities for each model term, where all remaining co-variates are set to zero (i.e. ignored). Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot.}
  \item{\code{"eff"}}{to plot marginal effects of predicted probabilities for each model term, where all remaining co-variates are set to the mean (see 'Details'). Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot.}
  \item{\code{"y.pc"}}{(or \code{"y.prob"}) to plot predicted probabilities for the response. See 'Details'.}
  \item{\code{"ma"}}{to check model assumptions. Note that only two arguments are relevant for this option \code{fit} and \code{showOriginalModelOnly}. All other arguments are ignored.}
  \item{\code{"vif"}}{to plot Variance Inflation Factors.}
}}

\item{sortOdds}{logical, if \code{TRUE} (default), odds ratios are ordered according their values from highest first
to lowest last. Use \code{FALSE} if you don't want to change the order of the predictors.}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details). If \code{title = ""},
no title is printed.}

\item{axisLabels.y}{labels or names of the predictor variables (independent vars). Must
be a character vector of same length as independent variables. The labels
may also be passed as list object; they will be coerced to character vector automatically.}

\item{axisTitle.x}{string; title for the x-axis.}

\item{axisLimits}{numeric vector of length 2, defining the range of the plot axis.
By default, the limits range from the lowest confidence interval to the
highest, so plot has maximum zoom.}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{gridBreaksAt}{set breaks for the axis, i.e. at every \code{gridBreaksAt}'th
position a major grid is being printed.}

\item{transformTicks}{logical, if \code{TRUE}, the grid lines have exponential
distances (equidistant), i.e. they visually have the same distance from
one panel grid to the next. If \code{FALSE}, grids are
plotted on every \code{gridBreaksAt}'s position, thus the grid lines become narrower with
higher odds ratio values.}

\item{geom.size}{size resp. width of the geoms (bar width or point size, depending on \code{type} argument).}

\item{geom.colors}{color palette for geoms. Must either be vector with two color values
or a specific color palette code. See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{hideErrorBars}{logical, if \code{TRUE}, the error bars that indicate the
confidence intervals of the odds ratios are not shown. Only applies
if argument \code{type = "bars"}. Default value is \code{FALSE}.}

\item{interceptLineType}{linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{color of the intercept line. Default value is \code{"grey70"}.}

\item{remove.estimates}{character vector with coefficient names that indicate
which estimates should be removed from the plot.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{coord.flip}{logical, if \code{TRUE} (default), predictors are plotted along the y-axis and estimate
values are plotted on the x-axis.}

\item{showIntercept}{logical, if \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}. Please note that due to exponential transformation of
estimates, the intercept in some cases can not be calculated, thus the
function call is interrupted and no plot printed.}

\item{showAxisLabels.y}{logical, whether labels of independent variables should be shown or not.}

\item{showValueLabels}{logical, whether value labels should be plotted to each dot or not.}

\item{labelDigits}{amount of digits for rounding the estimates (see \code{showValueLabels}).
Default is 2, i.e. estimates have 2 digits after decimal point.}

\item{showPValueLabels}{logical, whether the significance level of each coefficient
should be appended to values or not.}

\item{showModelSummary}{logical, if \code{TRUE}, a summary of the regression model with
Intercept, R-squared, F-Test and AIC-value is printed to the lower right corner
of the plot.}

\item{facet.grid}{logical, \code{TRUE} when each plot should be plotted separately instead of
an integrated (faceted) single graph. Only applies, if \code{type = "prob"}.}

\item{show.se}{logical, use \code{TRUE} to plot (depending on \code{type}) the standard
error for probability curves (predicted probabilities).}

\item{showOriginalModelOnly}{logical, if \code{TRUE} (default) and \code{type = "ma"},
         only the model assumptions of \code{fit} are plotted.
         If \code{FALSE}, the model assumptions of an updated model where outliers
         are automatically excluded are also plotted.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Invisibly) returns various objects, depending on
          the \code{type}-argument:
        \describe{
         \item{\code{type = "dots" or "bars"}}{
           \itemize{
             \item \code{df} - data frame used for the plot
             \item \code{plot} - plot as ggplot-object
           }
         }
         \item{\code{type = "prob" or "eff"}}{
           \itemize{
             \item \code{df.mp} - data frame used for predicted probability plots
             \item \code{plot.mp} - predicted probability plots as ggplot-objects
             \item \code{df.facet} - data frame used for faceted predicted probability plots
             \item \code{plot.facet} - facted predicted probability plots as ggplot-objects
           }
         }
         \item{\code{type = "y.pc"}}{
           \itemize{
             \item \code{df} - data frame used for the plot
             \item \code{plot} - plot as ggplot-object
             \item \code{mean.pp} - mean value of the predicted probabilities for the response
           }
         }
         \item{\code{type = "ma"}}{
           \itemize{
             \item \code{model} - updated model-fit with removed outliers
           }
         }
         \item{\code{type = "vif"}}{
           \itemize{
             \item \code{vifval} - a vector with vif-values
           }
         }
        }
}
\description{
Plot odds ratios (exponentiated coefficients) with confidence intervalls as bar chart or dot plot.
               Depending on the \code{type} argument, this function may also plot model
               assumptions for generalized linear models, or predicted probabilities
               of coefficients.
}
\details{
\describe{
           \item{\code{type = "prob"}}{(or \code{"pc"}), the predicted probabilities
           are based on the intercept's estimate and each specific term's estimate.
           All other co-variates are set to zero (i.e. ignored), which corresponds
           to \code{\link{plogis}(b0 + bx * x)} (where \code{x} is the logit-estimate).}
           \item{\code{type = "eff"}}{the predicted probabilities
           are based on the \code{\link{predict.glm}} method, where predicted values
           are "centered", i.e. remaining co-variates are set to the mean.
           (see \href{http://stats.stackexchange.com/questions/35682/contribution-of-each-covariate-to-a-single-prediction-in-a-logistic-regression-m#comment71993_35802}{CrossValidated}).
           Corresponds to \code{\link{plogis}(\link{predict}(fit, type = "terms") + attr(predict, "constant"))}.}
           \item{\code{type = "y.pc"}}{(or \code{type = "y.prob"}), the predicted values
           of the response are computed, based on the \code{\link{predict.glm}}
           method. Corresponds to \code{\link{predict}(fit, type = "response")}.}
         }
}
\examples{
# prepare dichotomous dependent variable
y <- ifelse(swiss$Fertility < median(swiss$Fertility), 0, 1)

# fit model
fitOR <- glm(y ~ swiss$Education + swiss$Examination + swiss$Infant.Mortality + swiss$Catholic,
             family = binomial(link = "logit"))

# print Odds Ratios as dots
sjp.glm(fitOR)

# print Odds Ratios as bars
sjp.glm(fitOR, type = "bars", geom.size = .3)


# -------------------------------
# Predictors for negative impact
# of care. Data from the EUROFAMCARE
# sample dataset
# -------------------------------
library(sjmisc)
data(efc)
# retrieve predictor variable labels
labs <- get_label(efc)
predlab <- c(labs[['c161sex']],
             paste0(labs[['e42dep']], " (slightly)"),
             paste0(labs[['e42dep']], " (moderate)"),
             paste0(labs[['e42dep']], " (severely)"),
             labs[['barthtot']],
             paste0(labs[['c172code']], " (mid)"),
             paste0(labs[['c172code']], " (high)"))
# create binary response
y <- ifelse(efc$neg_c_7 < median(na.omit(efc$neg_c_7)), 0, 1)
# create dummy variables for educational status
edu.mid <- ifelse(efc$c172code == 2, 1, 0)
edu.high <- ifelse(efc$c172code == 3, 1, 0)
# create data frame for fitted model
mydf <- data.frame(y = as.factor(y),
                   sex = as.factor(efc$c161sex),
                   dep = as.factor(efc$e42dep),
                   barthel = as.numeric(efc$barthtot),
                   edu.mid = as.factor(edu.mid),
                   edu.hi = as.factor(edu.high))
# fit model
fit <- glm(y ~., data = mydf, family = binomial(link = "logit"))
# plot odds
sjp.glm(fit,
        title = labs[['neg_c_7']],
        axisLabels.y = predlab)

# plot probability curves (predicted probabilities)
# of coefficients
sjp.glm(fit,
        title = labs[['neg_c_7']],
        axisLabels.y = predlab,
        type = "prob")
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.glm/}{sjPlot manual: sjp.glm}
}

