% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotGroupPropTable.R
\name{sjp.gpt}
\alias{sjp.gpt}
\title{Plot grouped proportional tables}
\usage{
sjp.gpt(x, y, groups, geom.colors = "Set1", geom.size = 2.5,
  shape.fill.color = "#f0f0f0", shapes = c(15, 16, 17, 18, 21, 22, 23, 24,
  25, 7, 8, 9, 10, 12), title = NULL, axis.labels = NULL,
  axis.titles = NULL, legend.title = NULL, legend.labels = NULL,
  wrap.title = 50, wrap.labels = 15, wrap.legend.title = 20,
  wrap.legend.labels = 20, axis.lim = NULL, grid.breaks = NULL,
  show.total = TRUE, annotate.total = TRUE, show.p = TRUE,
  show.n = TRUE, prnt.plot = TRUE)
}
\arguments{
\item{x}{categorical variable, where the proportion of each category in 
\code{x} for the highest category of \code{y} will be printed 
along the x-axis.}

\item{y}{categorical or numeric variable. If not a binary variable, \code{y}
will be recoded into a binary variable, dichtomized at the highest
category and all remaining categories.}

\item{groups}{grouping variable, which will define the y-axis}

\item{geom.colors}{user defined color for geoms. See 'Details' in \code{\link{sjp.grpfrq}}.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size, 
depending on plot type and function). Note that bar and bin widths mostly 
need smaller values than dot sizes.}

\item{shape.fill.color}{optional color vector, fill-color for non-filled shapes}

\item{shapes}{numeric vector with shape styles, used to map the different
categories of \code{x}.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{axis.titles}{character vector of length one or two, defining the title(s)
for the x-axis and y-axis.}

\item{legend.title}{character vector, used as title for the plot legend.}

\item{legend.labels}{character vector with labels for the guide/legend.}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis 
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title 
are displayed in one line and when a line break is inserted.}

\item{wrap.legend.labels}{numeric, determines how many chars of the legend labels are 
displayed in one line and when a line break is inserted.}

\item{axis.lim}{numeric vector of length 2, defining the range of the plot axis.
Depending on plot type, may effect either x- or y-axis, or both.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis, 
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{show.total}{logical, if \code{TRUE}, a total summary line for all aggregated
\code{groups} is added.}

\item{annotate.total}{logical, if \code{TRUE} and \code{show.total = TRUE},
the total-row in the figure will be highlighted with a slightly
shaded background.}

\item{show.p}{logical, adds significance levels to values, or value and 
variable labels.}

\item{show.n}{logical, if \code{TRUE}, adds total number of cases for each
group or category to the labels.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot
          (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df}).
}
\description{
Plot grouped proportional crosstables, where the proportion of
               each level of \code{x} for the highest category in \code{y}
               is plotted, for each subgroup of \code{groups}.
}
\details{
The p-values are based on \code{\link[stats]{chisq.test}} of \code{x} 
           and \code{y} for each \code{groups}.
}
\examples{
library(sjmisc)
data(efc)

# the proportion of dependency levels in female
# elderly, for each family carer's relationship
# to elderly
sjp.gpt(efc$e42dep, efc$e16sex, efc$e15relat)

# proportion of educational levels in highest
# dependency category of elderly, for different
# care levels
sjp.gpt(efc$c172code, efc$e42dep, efc$n4pstu)

}

