% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_theme.R
\name{set_theme}
\alias{set_theme}
\title{Set default theme for sjp-functions}
\usage{
set_theme(theme = c("forest", "538", "539", "scatter", "forestw", "538w",
  "539w", "scatterw", "blank"), ...)
}
\arguments{
\item{theme}{Name of a pre-set theme. May be one of:
\describe{
  \item{\code{"blank"}}{a theme with no grids and axes.}
  \item{\code{"forest"}}{a theme for forest plots, with no grids, in "539" style.}
  \item{\code{"538"}}{a grey-scaled theme inspired by \href{http://fivethirtyeight.com}{538-charts}, adapted from \href{http://minimaxir.com/2015/02/ggplot-tutorial/}{minimaxir.com}.}
  \item{\code{"539"}}{a slight modification of the 538-theme.}
  \item{\code{"scatter"}}{a theme for scatter plots in 539-theme-style.}
  \item{\code{"538w"}, \code{"539w"}, \code{"scatterw"} and \code{"forestw"}}{for themes as described above, however all with white backgrounds.}
}}

\item{...}{other arguments passed down to \code{\link{sjp.setTheme}}.}
}
\value{
The customized theme object.
}
\description{
Set default theme for sjp-functions.
}
\examples{
library(sjmisc)
data(efc)

# of the ggplot base theme
set_theme("539")
sjp.xtab(efc$e42dep, efc$e16sex)

}
\references{
\itemize{
             \item \href{http://zevross.com/blog/2014/08/04/beautiful-plotting-in-r-a-ggplot2-cheatsheet-3/}{Beautiful plotting in R: A ggplot2 cheatsheet}
             \item \href{http://minimaxir.com/2015/02/ggplot-tutorial/}{An Introduction on How to Make Beautiful Charts With R and ggplot2}
            }
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/custplot/}{sjPlot manual: customize plot appearance}
}

