% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotPolynomials.R
\name{sjp.poly}
\alias{sjp.poly}
\title{Plot polynomials for (generalized) linear regression}
\usage{
sjp.poly(x, poly.term, poly.degree, poly.scale = FALSE, fun = NULL,
  axis.title = NULL, geom.colors = NULL, geom.size = 0.8,
  show.loess = TRUE, show.loess.ci = TRUE, show.p = TRUE,
  show.scatter = TRUE, point.alpha = 0.2, point.color = "#404040",
  loess.color = "#808080", prnt.plot = TRUE)
}
\arguments{
\item{x}{A vector, representing the response variable of a linear (mixed) model; or
a linear (mixed) model as returned by \code{\link{lm}} or \code{\link[lme4]{lmer}}.}

\item{poly.term}{If \code{x} is a vector, \code{poly.term} should also be a vector, representing
the polynomial term (independent variabl) in the model; if \code{x} is a
fitted model, \code{poly.term} should be the polynomial term's name as character string.
See 'Examples'.}

\item{poly.degree}{Numeric, or numeric vector, indicating the degree of the polynomial.
If \code{poly.degree} is a numeric vector, multiple polynomial curves for
each degree are plotted. See 'Examples'.}

\item{poly.scale}{Logical, if \code{TRUE}, \code{poly.term} will be scaled before
linear regression is computed. Default is \code{FALSE}. Scaling the polynomial
term may have an impact on the resulting p-values.}

\item{fun}{Linear function when modelling polynomial terms. Use \code{fun = "lm"}
for linear models, or \code{fun = "glm"} for generalized linear models.
When \code{x} is not a vector, but a fitted model object, the function
is detected automatically. If \code{x} is a vector, \code{fun} defaults
to \code{"lm"}.}

\item{axis.title}{Character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis.
If not specified, a default labelling  is chosen. To set multiple
axis titles (e.g. with \code{type = "eff"} for many predictors),
\code{axis.title} must be a character vector of same length of plots
that are printed. In this case, each plot gets an own axis title
(applying, for instance, to the y-axis for \code{type = "eff"}).
\strong{Note:} Some plot types do not support this argument. In such
cases, use the return value and add axis titles manually with
\code{\link[ggplot2]{labs}}, e.g.: \code{$plot.list[[1]] + labs(x = ...)}}

\item{geom.colors}{User defined color palette for geoms. If \code{group.estimates}
is \emph{not} specified, must either be vector with two color values or a specific
color palette code (see 'Details' in \code{\link{sjp.grpfrq}}). Else, if
\code{group.estimates} is specified, \code{geom.colors} must be a vector
of same length as groups. See 'Examples'.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size,
depending on plot type and function). Note that bar and bin widths mostly
need smaller values than dot sizes.}

\item{show.loess}{Logical, if \code{TRUE}, an additional loess-smoothed line is plotted.}

\item{show.loess.ci}{Logical, if \code{TRUE}, a confidence region for the loess-smoothed line
will be plotted.}

\item{show.p}{Logical, if \code{TRUE} (default), p-values for polynomial terms are
printed to the console.}

\item{show.scatter}{Logical, if \code{TRUE} (default), adds a scatter plot of
data points to the plot. Only applies for slope-type or predictions plots.
For most plot types, dots are jittered to avoid overplotting, hence the
points don't reflect exact values in the data.}

\item{point.alpha}{Alpha value of point-geoms in the scatter plots. Only applies,
if \code{show.scatter = TRUE}.}

\item{point.color}{Color of of point-geoms in the scatter plots. Only applies,
if \code{show.scatter = TRUE}.}

\item{loess.color}{Color of the loess-smoothed line. Only applies, if \code{show.loess = TRUE}.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns
          \describe{
           \item{\code{plot}}{the ggplot-object with the complete plot}
           \item{\code{df}}{the data frame that was used for setting up the ggplot-object}
           \item{\code{cutpoints}}{a data frame that indicates x-values and predicted y-values of each direction change in the loess curvature}
          }
}
\description{
This function plots a scatter plot of a term \code{poly.term}
               against a response variable \code{x} and adds - depending on
               the amount of numeric values in \code{poly.degree} - multiple
               polynomial curves. A loess-smoothed line can be added to see
               which of the polynomial curves fits best to the data.
}
\details{
For each polynomial degree, a simple linear regression on \code{x} (resp.
           the extracted response, if \code{x} is a fitted model) is performed,
           where only the polynomial term \code{poly.term} is included as independent variable.
           Thus, \code{lm(y ~ x + I(x^2) + ... + I(x^i))} is repeatedly computed
           for all values in \code{poly.degree}, and the predicted values of
           the reponse are plotted against the raw values of \code{poly.term}.
           If \code{x} is a fitted model, other covariates are ignored when
           finding the best fitting polynomial. \cr \cr
           This function evaluates raw polynomials, \emph{not orthogonal} polynomials.
           Polynomials are computed using the \code{\link{poly}} function,
           with argument \code{raw = TRUE}. \cr \cr
           To find out which polynomial degree fits best to the data, a loess-smoothed
           line (in dark grey) can be added (with \code{show.loess = TRUE}). The polynomial curves
           that comes closest to the loess-smoothed line should be the best
           fit to the data.
}
\examples{
library(sjmisc)
data(efc)
# linear fit. loess-smoothed line indicates a more
# or less cubic curve
sjp.poly(efc$c160age, efc$quol_5, 1)

# quadratic fit
sjp.poly(efc$c160age, efc$quol_5, 2)

# linear to cubic fit
sjp.poly(efc$c160age, efc$quol_5, 1:4, show.scatter = FALSE)


# fit sample model
fit <- lm(tot_sc_e ~ c12hour + e17age + e42dep, data = efc)
# inspect relationship between predictors and response
plot_model(fit, type = "slope")
# "e17age" does not seem to be linear correlated to response
# try to find appropiate polynomial. Grey line (loess smoothed)
# indicates best fit. Looks like x^4 has the best fit,
# however, only x^3 has significant p-values.
sjp.poly(fit, "e17age", 2:4, show.scatter = FALSE)

\dontrun{
# fit new model
fit <- lm(tot_sc_e ~ c12hour + e42dep + e17age + I(e17age^2) + I(e17age^3),
          data = efc)
# plot marginal effects of polynomial term
plot_model(fit, type = "pred", terms = "e17age")}

}
\seealso{
To plot marginal effects of polynomial terms, call \code{\link{sjp.lm}} with \code{type = "poly"},
           or \code{\link{sjp.lmer}} respectively for linear mixed models.
}
