% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add_labels.R
\name{add_labels}
\alias{add_labels}
\title{Add value labels to variables}
\usage{
add_labels(x, labels)
}
\arguments{
\item{x}{Variable (vector), \code{list} of variables or a \code{data.frame}
where value label attributes should be added. Does not replaces former
value labels.}

\item{labels}{Named character vector of labels that will be added to \code{x} as
         \code{"labels"} or \code{"value.labels"} attribute. If \code{x} is
         a data frame, \code{labels} may also be a \code{\link{list}} of
         named character vectors. If \code{labels} is a list, it must have
         the same length as number of columns of \code{x}. If \code{labels}
         is a vector and \code{x} is a data frame, \code{labels} will be applied
         to each column of \code{x}.}
}
\value{
\code{x} with additional value labels.
}
\description{
This function adds additional labels as attribute to a variable
               or vector \code{x}, resp. to a set of variables in a
               \code{data.frame} or \code{list}-object. Unlike \code{\link{set_labels}},
               \code{add_labels} does not replace existing value labels, but add
               \code{labels} to the existing value labels of \code{x}.
}
\note{
Existing labelled values will be replaced by new labelled values
        in \code{labels}. See 'Examples'.
}
\examples{
data(efc)
get_labels(efc$e42dep)

x <- add_labels(efc$e42dep, c(`5` = "nothing"))
get_labels(x)

x <- add_labels(efc$e42dep, c(`5` = "nothing", `0` = "zero value"))
get_labels(x, include.values = "p")

# replace old values
x <- add_labels(efc$e42dep, c(`4` = "not so dependent", `5` = "lorem ipsum"))
get_labels(x, include.values = "p")
}
\seealso{
\code{\link{set_label}} to manually set variable labels or
           \code{\link{get_label}} to get variable labels; \code{\link{set_labels}} to
           add value labels, replacing the existing ones.
}

