% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_var.R
\name{group_labels}
\alias{group_labels}
\title{Create labels for recoded groups}
\usage{
group_labels(x, groupsize = 5, right.interval = FALSE, groupcount = 30)
}
\arguments{
\item{x}{Numeric variable, which should recoded into groups, or a list or
data frame with such variables.}

\item{groupsize}{Numeric; group-size, i.e. the range for grouping. By default,
for each 5 categories of \code{x} a new group is defined, i.e. \code{groupsize=5}.
Use \code{groupsize = "auto"} to automatically resize a variable into
a maximum of 30 groups (which is the ggplot-default grouping when
plotting histograms). Use \code{groupcount} to determine the amount
of groups.}

\item{right.interval}{Logical; if \code{TRUE}, grouping starts with the lower
bound of \code{groupsize}. See 'Details'.}

\item{groupcount}{Sets the maximum number of groups that are defined when auto-grouping is on
(\code{groupsize="auto"}). Default is 30. If \code{groupsize} is not set to \code{"auto"},
this argument will be ignored.}
}
\value{
A string vector or a list of string vectors containing labels based
          on the grouped categories of \code{x}, formatted as "from lower bound to upper bound",
          e.g. \code{"10-19"  "20-29"  "30-39"} etc. See 'Examples'.
}
\description{
Creates the related labels for the grouped variable created by
               \code{\link{group_var}}.
}
\details{
See 'Details' in \code{\link{group_var}}.
}
\note{
Usually you should use the same values for \code{groupsize} and
        \code{right.interval} as used in the \code{\link{group_var}} function
        if you want to create labels for the related recoded variable.

Variable label attributes (see, for instance, \code{\link{set_label}}) are preserved.
}
\examples{
age <- abs(round(rnorm(100, 65, 20)))
age.grp <- group_var(age, 10)
hist(age)
hist(age.grp)

age.grpvar <- group_labels(age, 10)
table(age.grp)
print(age.grpvar)


# create vector with values from 50 to 80
dummy <- round(runif(200, 50, 80))
# labels with grouping starting at lower bound
group_labels(dummy)
# labels with grouping startint at upper bound
group_labels(dummy, right.interval = TRUE)


# histogram with EUROFAMCARE sample dataset
# variable not grouped
data(efc)
hist(efc$e17age, main = get_label(efc$e17age))

# bar plot with EUROFAMCARE sample dataset
# grouped variable
ageGrp <- group_var(efc$e17age)
ageGrpLab <- group_labels(efc$e17age)
barplot(table(ageGrp), main = get_label(efc$e17age), names.arg = ageGrpLab)

}
\seealso{
\itemize{
           \item \code{\link{group_var}}
           \item \code{\link{group_str}}
         }
}

