% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_pos.R
\name{str_pos}
\alias{str_pos}
\title{Find partial matching and close distance elements in strings}
\usage{
str_pos(searchString, findTerm, maxdist = 2, part.dist.match = 0,
  showProgressBar = FALSE)
}
\arguments{
\item{searchString}{Character vector with string elements.}

\item{findTerm}{String that should be matched against the elements of \code{searchString}.}

\item{maxdist}{Maximum distance between two string elements, which is allowed to treat them
as similar or equal. Smaller values mean less tolerance in matching.}

\item{part.dist.match}{Activates similar matching (close distance strings) for parts (substrings)
of the \code{searchString}. Following values are accepted:
\itemize{
  \item 0 for no partial distance matching
  \item 1 for one-step matching, which means, only substrings of same length as \code{findTerm} are extracted from \code{searchString} matching
  \item 2 for two-step matching, which means, substrings of same length as \code{findTerm} as well as strings with a slightly wider range are extracted from \code{searchString} matching
}
Default value is 0. See 'Details' for more information.}

\item{showProgressBar}{Logical; f \code{TRUE}, the progress bar is displayed when computing the distance matrix.
Default in \code{FALSE}, hence the bar is hidden.}
}
\value{
A numeric vector with index position of elements in \code{searchString} that
          partially match or are similar to \code{findTerm}. Returns \code{-1} if no
          match was found.
}
\description{
This function finds the element indices of partial matching or similar strings
               in a character vector. Can be used to find exact or slightly mistyped elements
               in a string vector.
}
\details{
For \code{part.dist.match = 1}, a substring of \code{length(findTerm)} is extracted
           from \code{searchString}, starting at position 0 in \code{searchString} until
           the end of \code{searchString} is reached. Each substring is matched against
           \code{findTerm}, and results with a maximum distance of \code{maxdist}
           are considered as "matching". If \code{part.dist.match = 2}, the range
           of the extracted substring is increased by 2, i.e. the extracted substring
           is two chars longer and so on.
}
\note{
This function does \emph{not} return the position of a matching string \emph{inside}
        another string, but the element's index of the \code{searchString} vector, where
        a (partial) match with \code{findTerm} was found. Thus, searching for "abc" in
        a string "this is abc" will not return 9 (the start position of the substring),
        but 1 (the element index, which is always 1 if \code{searchString} only has one element).
}
\examples{
\dontrun{
string <- c("Hello", "Helo", "Hole", "Apple", "Ape", "New", "Old", "System", "Systemic")
str_pos(string, "hel")   # partial match
str_pos(string, "stem")  # partial match
str_pos(string, "R")     # no match
str_pos(string, "saste") # similarity to "System"

# finds two indices, because partial matching now
# also applies to "Systemic"
str_pos(string,
        "sytsme",
        part.dist.match = 1)

# finds nothing
str_pos("We are Sex Pistols!", "postils")
# finds partial matching of similarity
str_pos("We are Sex Pistols!", "postils", part.dist.match = 1)}

}
\seealso{
\code{\link{group_str}}
}

