% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_wrap.R
\name{word_wrap}
\alias{word_wrap}
\title{Insert line breaks in long labels}
\usage{
word_wrap(labels, wrap, linesep = NULL)
}
\arguments{
\item{labels}{Label(s) as character string, where a line break should be
inserted. Several strings may be passed as vector  (see 'Examples').}

\item{wrap}{Maximum amount of chars per line (i.e. line length). If code{wrap = Inf},
no word wrap will be performed (i.e. \code{labels} will be returned as is).}

\item{linesep}{By default, this argument is \code{NULL} and a regular new line
string (\code{"\\n"}) is used. For HTML-purposes, for instance, \code{linesep}
could be \code{"<br>"}.}
}
\value{
New label(s) with line breaks inserted at every \code{wrap}'s position.
}
\description{
Insert line breaks in long character strings. Useful if you want to wordwrap
               labels / titles for plots or tables.
}
\examples{
word_wrap(c("A very long string", "And another even longer string!"), 10)

message(word_wrap("Much too long string for just one line!", 15))

}
